/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import net.argius.filetool.Compressor;
import net.argius.filetool.IOUtilities;

public final class GzipCompressor
extends OutputStream
implements Compressor {
    private GZIPOutputStream gos;

    public GzipCompressor(OutputStream outputStream) throws IOException {
        this.gos = new GZIPOutputStream(outputStream);
    }

    public void compress(InputStream inputStream) throws IOException {
        IOUtilities.transferAll(inputStream, this.gos);
    }

    public void write(int n) throws IOException {
        this.gos.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.gos.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.gos.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.gos.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.gos.close();
        }
        finally {
            super.close();
        }
    }
}

