/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.argius.filetool.ArchiveEntry;
import net.argius.filetool.ArchiveType;
import net.argius.filetool.Bzip2Decompressor;
import net.argius.filetool.Expander;
import net.argius.filetool.GzipDecompressor;
import net.argius.filetool.IOUtilities;
import net.argius.filetool.LhaExpander;
import net.argius.filetool.TarExpander;
import net.argius.filetool.Utilities;
import net.argius.filetool.ZipExpander;

public final class FileExpander {
    private Expander expander;
    static /* synthetic */ Class class$net$argius$filetool$DiskUsage;

    public FileExpander(File file) throws IOException {
        this(file, ArchiveType.getType(file));
    }

    public FileExpander(File file, ArchiveType archiveType) throws IOException {
        if (archiveType == ArchiveType.TAR) {
            this.expander = new TarExpander(new FileInputStream(file));
        } else if (archiveType == ArchiveType.TGZ) {
            this.expander = new TarExpander(new GzipDecompressor(new FileInputStream(file)));
        } else if (archiveType == ArchiveType.TBZ) {
            this.expander = new TarExpander(new Bzip2Decompressor(new FileInputStream(file)));
        } else if (archiveType == ArchiveType.ZIP) {
            this.expander = new ZipExpander(file);
        } else if (archiveType == ArchiveType.LZH) {
            this.expander = new LhaExpander(new FileInputStream(file));
        } else {
            throw new IllegalStateException("ArchiverType: " + archiveType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + file);
        }
        try {
            ArchiveEntry archiveEntry;
            while ((archiveEntry = this.expander.nextEntry()) != ArchiveEntry.EMPTY) {
                if (archiveEntry.isDirectory()) continue;
                File file2 = File.createTempFile("filetool-expand-", ".tmp");
                file2.deleteOnExit();
                String string = archiveEntry.getName();
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    this.expander.expand(fileOutputStream);
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
                File file3 = new File(file, string);
                if (file3.isDirectory()) continue;
                IOUtilities.move(file2, file3, false);
                file3.setLastModified(archiveEntry.getLastModified());
            }
        }
        finally {
            this.expander.close();
        }
    }

    public void close() throws IOException {
        this.expander.close();
    }

    private static void printUsage() {
        PrintStream printStream = System.err;
        printStream.println("FileArchiver (argius-filetool)");
        printStream.println("usage : (command) src [dst]");
        printStream.println("options: none");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length < 1) {
            FileExpander.printUsage();
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals("-h") && !string.equals("--help")) continue;
            FileExpander.printUsage();
            return;
        }
        try {
            File file = new File(stringArray[0]);
            File file2 = new File(stringArray.length >= 2 ? stringArray[1] : ".");
            FileExpander fileExpander = new FileExpander(file);
            try {
                fileExpander.expand(file2);
            }
            finally {
                fileExpander.close();
            }
            n = 0;
        }
        catch (IOException iOException) {
            System.out.println("FileExpander: " + iOException.getMessage());
            n = 1;
        }
        catch (Exception exception) {
            String string = exception + Utilities.getFirstStackTrace(exception, class$net$argius$filetool$DiskUsage == null ? (class$net$argius$filetool$DiskUsage = FileExpander.class$("net.argius.filetool.DiskUsage")) : class$net$argius$filetool$DiskUsage);
            System.out.println("FileExpander: " + string);
            n = 255;
        }
        if (n > 0) {
            System.exit(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

