/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import net.argius.filetool.Bzip2Decompressor;
import net.argius.filetool.CompressType;
import net.argius.filetool.GzipDecompressor;
import net.argius.filetool.IOUtilities;
import net.argius.filetool.Utilities;

public final class FileDecompressor {
    static /* synthetic */ Class class$net$argius$filetool$DiskUsage;

    public static void decompress(File file) throws IOException {
        String string;
        String string2 = file.getName();
        CompressType compressType = CompressType.getType(file);
        if (compressType == CompressType.GZIP) {
            string = string2.substring(0, string2.length() - 3);
        } else if (compressType == CompressType.BZIP2) {
            string = string2.substring(0, string2.length() - 4);
        } else {
            throw new IllegalArgumentException("can't detect type by suffix");
        }
        File file2 = new File(file.getParentFile(), string);
        FileDecompressor.decompress(file, file2, compressType);
    }

    public static void decompress(File file, File file2) throws IOException {
        FileDecompressor.decompress(file, file2, CompressType.getType(file));
    }

    public static void decompress(File file, CompressType compressType) throws IOException {
        File file2;
        if (compressType == CompressType.GZIP) {
            file2 = new File(file.getParentFile(), file.getName() + ".gz");
        } else if (compressType == CompressType.BZIP2) {
            file2 = new File(file.getParentFile(), file.getName() + ".bz2");
        } else {
            throw new IllegalArgumentException();
        }
        FileDecompressor.decompress(file, file2, compressType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompress(File file, File file2, CompressType compressType) throws IOException {
        InputStream inputStream;
        File file3 = Utilities.createTemporaryFile();
        if (compressType == CompressType.GZIP) {
            inputStream = new GzipDecompressor(new FileInputStream(file));
        } else if (compressType == CompressType.BZIP2) {
            inputStream = new Bzip2Decompressor(new FileInputStream(file));
        } else {
            throw new IllegalArgumentException();
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            try {
                inputStream.decompress(fileOutputStream);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        finally {
            inputStream.close();
        }
        IOUtilities.move(file3, file2, false);
        file2.setLastModified(file.lastModified());
    }

    private static void printUsage() {
        PrintStream printStream = System.err;
        printStream.println("FileDecompressor (argius-filetool)");
        printStream.println("usage : (command) src [dst]");
        printStream.println("options: none");
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length < 1) {
            FileDecompressor.printUsage();
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals("-h") && !string.equals("--help")) continue;
            FileDecompressor.printUsage();
            return;
        }
        try {
            if (stringArray.length >= 2) {
                FileDecompressor.decompress(new File(stringArray[0]), new File(stringArray[1]));
            } else {
                FileDecompressor.decompress(new File(stringArray[0]));
            }
            n = 0;
        }
        catch (IOException iOException) {
            System.out.println("FileDecompressor: " + iOException.getMessage());
            n = 1;
        }
        catch (Exception exception) {
            String string = exception + Utilities.getFirstStackTrace(exception, class$net$argius$filetool$DiskUsage == null ? (class$net$argius$filetool$DiskUsage = FileDecompressor.class$("net.argius.filetool.DiskUsage")) : class$net$argius$filetool$DiskUsage);
            System.out.println("FileDecompressor: " + string);
            n = 255;
        }
        if (n > 0) {
            System.exit(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

