/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.argius.filetool.Utilities;

public class DiskUsage {
    private PrintWriter out;
    private PrintWriter err;
    private boolean messageEnables;
    private int lower;
    private int upper;
    static /* synthetic */ Class class$net$argius$filetool$DiskUsage;

    public DiskUsage() {
        this(new PrintWriter(System.out, true));
    }

    public DiskUsage(PrintWriter printWriter) {
        this(printWriter, new PrintWriter(System.err, true));
    }

    public DiskUsage(PrintWriter printWriter, PrintWriter printWriter2) {
        this.out = printWriter;
        this.err = printWriter2;
        this.messageEnables = false;
        this.lower = 0;
        this.upper = Integer.MAX_VALUE;
    }

    public final boolean isMessageEnables() {
        return this.messageEnables;
    }

    public final void setMessageEnables(boolean bl) {
        this.messageEnables = bl;
    }

    public final void setRange(int n, int n2) {
        if (n > n2 || n < 0 || n2 < 0) {
            throw new IllegalArgumentException("range: " + n + ',' + n2);
        }
        this.lower = n;
        this.upper = n2;
    }

    public void printInfo(long l, int n, File file) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = String.valueOf(l).length();
        if (n2 < 19) {
            stringBuffer.append("                   ".substring(n2));
        }
        stringBuffer.append(l);
        stringBuffer.append('\t');
        int n3 = String.valueOf(n).length();
        if (n3 < 2) {
            stringBuffer.append("  ".substring(n3));
        }
        stringBuffer.append(n);
        stringBuffer.append('\t');
        stringBuffer.append(file.getPath());
        this.out.println(stringBuffer);
    }

    public void printMessage(Object object) {
        if (this.messageEnables) {
            this.err.println(" ... scanning " + object);
        }
    }

    protected boolean isOutputEnables(PrintWriter printWriter, File file, int n) {
        if (printWriter == this.out && this.isInRange(n)) {
            return true;
        }
        if (printWriter == this.err) {
            return this.upper - this.lower < 2 || this.lower <= n && n < this.upper;
        }
        return false;
    }

    protected int getDepth(File file) {
        String string = file.getPath().replace(File.separatorChar, '/');
        if (string.endsWith(String.valueOf('/'))) {
            string = string.substring(0, string.length() - 1);
        }
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(47, n2)) >= 0) {
            ++n;
            ++n2;
        }
        return n;
    }

    protected final boolean isInRange(int n) {
        return this.lower <= n && n <= this.upper;
    }

    public final long output(File file) {
        if (!file.isDirectory()) {
            return file.length();
        }
        int n = this.getDepth(file);
        long l = 0L;
        File[] fileArray = file.listFiles();
        if (this.messageEnables && this.isOutputEnables(this.err, file, n)) {
            this.printMessage(file);
        }
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                l += this.output(file2);
            }
        }
        if (this.isOutputEnables(this.out, file, n)) {
            this.printInfo(l, n, file);
        }
        return l;
    }

    public final long getSize(File file) {
        if (!file.isDirectory()) {
            return file.length();
        }
        long l = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                l += this.getSize(file2);
            }
        }
        return l;
    }

    private static void invoke(String[] stringArray) {
        int n;
        DiskUsage diskUsage = new DiskUsage();
        diskUsage.setMessageEnables(true);
        diskUsage.setRange(0, 3);
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            if (string.startsWith("-")) {
                if (string.equals("-q") || string.equals("--quit")) {
                    diskUsage.setMessageEnables(false);
                    continue;
                }
                if (string.equals("--total")) {
                    bl = true;
                    continue;
                }
                if (string.equals("-r") || string.equals("--range")) {
                    int n2;
                    int n3;
                    if (stringArray.length <= (n += 2)) {
                        throw new IllegalArgumentException("invalid option: range requires 2 parameters");
                    }
                    try {
                        n3 = Integer.parseInt(stringArray[n - 1]);
                        n2 = Integer.parseInt(stringArray[n]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("invalid range parameter: " + numberFormatException.getMessage());
                    }
                    diskUsage.setRange(n3, n2);
                    continue;
                }
                throw new IllegalArgumentException("invalid option: " + string);
            }
            arrayList.add(string);
        }
        int n4 = arrayList.size();
        for (n = 0; n < n4; ++n) {
            File file = new File((String)arrayList.get(n));
            if (bl) {
                long l = diskUsage.getSize(file);
                StringBuffer stringBuffer = new StringBuffer();
                int n5 = String.valueOf(l).length();
                if (n5 < 19) {
                    stringBuffer.append("                   ".substring(n5));
                }
                stringBuffer.append(l);
                stringBuffer.append('\t');
                stringBuffer.append(file.getPath());
                System.out.println(stringBuffer);
                continue;
            }
            diskUsage.output(file);
        }
    }

    private static void printUsage() {
        PrintStream printStream = System.err;
        printStream.println("DiskUsage (argius-filetool)");
        printStream.println("usage : (command) [path...]");
        printStream.println("options: ");
        printStream.println("  -q, --quit   suppress messages");
        printStream.println("  -r, --range  setting range to show infos and messages");
        printStream.println("      --total  do print total size only");
        printStream.println("  -h, --help   show (this) help");
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length == 0) {
            DiskUsage.printUsage();
            return;
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            if (!string.equals("-h") && !string.equals("--help")) continue;
            DiskUsage.printUsage();
            return;
        }
        try {
            DiskUsage.invoke(stringArray);
            n = 0;
        }
        catch (Exception exception) {
            String string = exception + Utilities.getFirstStackTrace(exception, class$net$argius$filetool$DiskUsage == null ? (class$net$argius$filetool$DiskUsage = DiskUsage.class$("net.argius.filetool.DiskUsage")) : class$net$argius$filetool$DiskUsage);
            System.out.println("DiskUsage: " + string);
            n = 255;
        }
        if (n > 0) {
            System.exit(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

