/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.File;

public final class CompressType {
    public static final CompressType GZIP = new CompressType("GZ");
    public static final CompressType BZIP2 = new CompressType("BZIP2");
    public static final CompressType UNKNOWN = new CompressType("UNKNOWN");
    private final String typeName;

    private CompressType(String string) {
        this.typeName = string;
    }

    static CompressType getType(File file) {
        if (!file.isDirectory()) {
            String string = file.getName().toLowerCase();
            if (string.endsWith(".gz")) {
                return GZIP;
            }
            if (string.endsWith(".bz2")) {
                return BZIP2;
            }
        }
        return UNKNOWN;
    }

    public String toString() {
        return "CompressType:" + this.typeName;
    }
}

