/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.argius.filetool.Decompressor;
import net.argius.filetool.IOUtilities;
import org.apache.tools.bzip2.CBZip2InputStream;

public final class Bzip2Decompressor
extends InputStream
implements Decompressor {
    private CBZip2InputStream bis;

    public Bzip2Decompressor(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtilities.transfer(inputStream, byteArrayOutputStream, 2L);
        String string = new String(byteArrayOutputStream.toByteArray(), "ISO8859-1");
        if (!string.equals("BZ")) {
            throw new IOException("bad file identifier: " + string);
        }
        this.bis = new CBZip2InputStream(inputStream);
    }

    public void decompress(OutputStream outputStream) throws IOException {
        IOUtilities.transferAll((InputStream)this.bis, outputStream);
    }

    public int available() throws IOException {
        return this.bis.available();
    }

    public int read() throws IOException {
        return this.bis.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.bis.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.bis.read(byArray, n, n2);
    }

    public void mark(int n) {
        this.bis.mark(n);
    }

    public boolean markSupported() {
        return this.bis.markSupported();
    }

    public void reset() throws IOException {
        this.bis.reset();
    }

    public long skip(long l) throws IOException {
        return this.bis.skip(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.bis.close();
        }
        finally {
            super.close();
        }
    }
}

