/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.argius.filetool.Compressor;
import net.argius.filetool.IOUtilities;
import org.apache.tools.bzip2.CBZip2OutputStream;

public final class Bzip2Compressor
extends OutputStream
implements Compressor {
    private CBZip2OutputStream bos;

    public Bzip2Compressor(OutputStream outputStream) throws IOException {
        outputStream.write(new byte[]{66, 90});
        this.bos = new CBZip2OutputStream(outputStream);
    }

    public void compress(InputStream inputStream) throws IOException {
        IOUtilities.transferAll(inputStream, (OutputStream)this.bos);
    }

    public void write(int n) throws IOException {
        this.bos.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        this.bos.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.bos.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.bos.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.bos.close();
        }
        finally {
            super.close();
        }
    }
}

