package net.argius.filetool;

import java.io.*;
import java.util.*;
import java.util.zip.*;

import jp.gr.java_conf.dangan.util.lha.*;

/**
 * LHAA[JCoB
 * jLHAgpLZH`̃A[JCu쐬B
 */
public final class LhaArchiver implements Archiver {

    private LhaOutputStream los;
    private boolean includesDirectory;

    /**
     * LhaArchiver̐B
     * @param os o͐Xg[
     */
    public LhaArchiver(OutputStream os) {
        this.los = new LhaOutputStream(os);
        this.includesDirectory = true;
    }

    /**
     * includesDirectory̐ݒB
     * @param includesDirectory includesDirectory
     */
    public void setIncludesDirectory(boolean includesDirectory) {
        this.includesDirectory = includesDirectory;
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Archiver#addEntry(net.argius.filetool.compress.ArchiverEntry, java.io.InputStream, int, long)
     */
    public void addEntry(ArchiveEntry ae, InputStream is, long length) throws IOException {
        if (ae.isDirectory()) {
            // fBNg
            if (includesDirectory) {
                LhaHeader header = new LhaHeader(ae.getName());
                header.setCompressMethod(CompressMethod.LHD);
                header.setCRC(0);
                header.setOriginalSize(0);
                header.setCompressedSize(0);
                header.setLastModified(new Date(ae.getLastModified()));
                los.putNextEntry(header);
                los.closeEntry();
            }
        } else {
            // t@C
            LhaHeader header = new LhaHeader(ae.getName());
            los.putNextEntry(header);
            CheckedInputStream cis = new CheckedInputStream(is, new CRC32());
            long totalSize = IOUtilities.transferAll(cis, los);
            header.setCRC((int)cis.getChecksum().getValue()); // long->int
            header.setOriginalSize(totalSize);
            header.setCompressedSize(totalSize);
            header.setLastModified(new Date(ae.getLastModified()));
            los.closeEntry();
        }
    }

    /* (overridden)
     * @see java.io.Closeable#close()
     */
    public void close() throws IOException {
        los.close();
    }

}
