package net.argius.filetool;

import java.io.*;

/**
 * t@C𓀏B
 */
public final class FileDecompressor {

    /**
     * t@C𓀂B
     * o͐t@ĆAt@C̈k^Cv̊gq̂ɂȂB
     * @param src 𓀌t@C
     * @throws IOException o̓G[ꍇ
     */
    public static void decompress(File src) throws IOException {
        String name = src.getName();
        String newName;
        CompressType type = CompressType.getType(src);
        if (type == CompressType.GZIP) {
            newName = name.substring(0, name.length() - 3);
        } else if (type == CompressType.BZIP2) {
            newName = name.substring(0, name.length() - 4);
        } else {
            throw new IllegalArgumentException("can't detect type by suffix");
        }
        File dst = new File(src.getParentFile(), newName);
        decompress(src, dst, type);
    }

    /**
     * t@C𓀂B
     * @param src 𓀌t@C
     * @param dst o͐t@C
     * @throws IOException o̓G[ꍇ
     */
    public static void decompress(File src, File dst) throws IOException {
        decompress(src, dst, CompressType.getType(src));
    }

    /**
     * t@C𓀂B
     * @param src 𓀌t@C
     * @param type k^Cv
     * @throws IOException o̓G[ꍇ
     */
    public static void decompress(File src, CompressType type) throws IOException {
        File dst;
        if (type == CompressType.GZIP) {
            dst = new File(src.getParentFile(), src.getName() + ".gz");
        } else if (type == CompressType.BZIP2) {
            dst = new File(src.getParentFile(), src.getName() + ".bz2");
        } else {
            throw new IllegalArgumentException();
        }
        decompress(src, dst, type);
    }

    /**
     * t@C𓀂B
     * @param src 𓀌t@C
     * @param dst o͐t@C
     * @param type k^Cv
     * @throws IOException o̓G[ꍇ
     */
    public static void decompress(File src, File dst, CompressType type) throws IOException {
        File tmp = Utilities.createTemporaryFile();
        Decompressor decompressor;
        if (type == CompressType.GZIP) {
            decompressor = new GzipDecompressor(new FileInputStream(src));
        } else if (type == CompressType.BZIP2) {
            decompressor = new Bzip2Decompressor(new FileInputStream(src));
        } else {
            throw new IllegalArgumentException();
        }
        try {
            OutputStream os = new FileOutputStream(tmp);
            try {
                decompressor.decompress(os);
            } finally {
                os.close();
            }
        } finally {
            decompressor.close();
        }
        IOUtilities.move(tmp, dst, false);
        dst.setLastModified(src.lastModified());
    }

    /**
     * g̕\B
     */
    private static void printUsage() {
        PrintStream err = System.err;
        err.println("FileDecompressor (argius-filetool)");
        err.println("usage : (command) src [dst]");
        err.println("options: none");
    }

    /**
     * FileDecompressor̎sB
     * @param args p[^(see 'usage')
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            printUsage();
            return;
        }
        for (int i = 0; i < args.length; i++) {
            String arg = args[i];
            if (arg.equals("-h") || arg.equals("--help")) {
                printUsage();
                return;
            }
        }
        final String commandNameInfo = "FileDecompressor: ";
        int status;
        try {
            if (args.length >= 2) {
                FileDecompressor.decompress(new File(args[0]), new File(args[1]));
            } else {
                FileDecompressor.decompress(new File(args[0]));
            }
            status = 0;
        } catch (IOException ex) {
            System.out.println(commandNameInfo + ex.getMessage());
            status = 1;
        } catch (Exception ex) {
            String message = ex + Utilities.getFirstStackTrace(ex, DiskUsage.class);
            System.out.println(commandNameInfo + message);
            status = 255;
        }
        if (status > 0) {
            System.exit(status);
        }
    }

}
