package net.argius.filetool;

import java.io.*;

/**
 * k^CvB
 */
public final class CompressType {

    /**
     * <code>GZIP</code>
     */
    public static final CompressType GZIP = new CompressType("GZ");

    /**
     * <code>BZIP2</code>
     */
    public static final CompressType BZIP2 = new CompressType("BZIP2");

    /**
     * sȃ^CvB
     */
    public static final CompressType UNKNOWN = new CompressType("UNKNOWN");

    private final String typeName;

    /**
     * CompressType̐B
     * @param typeName ^Cv 
     */
    private CompressType(String typeName) {
        this.typeName = typeName;
    }

    /**
     * ^Cv̎擾B
     * @param file t@C
     * @return ^Cv
     */
    static CompressType getType(File file) {
        if (!file.isDirectory()) {
            String nameLC = file.getName().toLowerCase();
            if (nameLC.endsWith(".gz")) {
                return GZIP;
            }
            if (nameLC.endsWith(".bz2")) {
                return BZIP2;
            }
        }
        return UNKNOWN;
    }

    /* (overridden)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "CompressType:" + typeName;
    }

}
