package net.argius.filetool;

import java.io.*;

import org.apache.tools.bzip2.*;

/**
 * BZIP2kB
 * AntAPIgpBZIP2`̈ksB
 */
public final class Bzip2Compressor extends OutputStream implements Compressor {

    private CBZip2OutputStream bos;

    /**
     * GzipCompressor̐B
     * @param os 
     * @throws IOException 
     */
    public Bzip2Compressor(OutputStream os) throws IOException {
        os.write(new byte[]{(byte)0x42, (byte)0x5A}); // id=BZ
        this.bos = new CBZip2OutputStream(os);
    }

    /* (overridden)
     * @see net.argius.filetool.compress.Compressor#compress(java.io.InputStream, java.io.OutputStream)
     */
    public void compress(InputStream is) throws IOException {
        IOUtilities.transferAll(is, bos);
    }

    /* (overridden)
     * @see java.io.OutputStream#write(int)
     */
    public void write(int b) throws IOException {
        bos.write(b);
    }

    /* (overridden)
     * @see java.io.OutputStream#write(byte[])
     */
    public void write(byte[] b) throws IOException {
        bos.write(b);
    }

    /* (overridden)
     * @see java.io.OutputStream#write(byte[], int, int)
     */
    public void write(byte[] b, int off, int len) throws IOException {
        bos.write(b, off, len);
    }

    /* (overridden)
     * @see java.io.OutputStream#flush()
     */
    public void flush() throws IOException {
        bos.flush();
    }

    /* (overridden)
     * @see java.io.OutputStream#close()
     */
    public void close() throws IOException {
        try {
            bos.close();
        } finally {
            super.close();
        }
    }

}
