/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.argius.filetool.IOUtilities;
import net.argius.filetool.compress.Archiver;
import net.argius.filetool.compress.ArchiverEntry;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public final class TarArchiver
implements Archiver {
    private final TarOutputStream tos;
    private boolean includesDirectory;

    public TarArchiver(OutputStream outputStream) {
        this.tos = new TarOutputStream(outputStream);
        this.includesDirectory = true;
    }

    public void setIncludesDirectory(boolean bl) {
        this.includesDirectory = bl;
    }

    public void addEntry(ArchiverEntry archiverEntry, InputStream inputStream, long l) throws IOException {
        if (archiverEntry.isDirectory()) {
            if (this.includesDirectory) {
                TarEntry tarEntry = new TarEntry(archiverEntry.getName());
                tarEntry.setModTime(archiverEntry.getLastModified());
                this.tos.putNextEntry(tarEntry);
                this.tos.closeEntry();
            }
        } else {
            TarEntry tarEntry = new TarEntry(archiverEntry.getName());
            tarEntry.setSize(l);
            tarEntry.setModTime(archiverEntry.getLastModified());
            this.tos.putNextEntry(tarEntry);
            IOUtilities.transferAll(inputStream, (OutputStream)this.tos);
            this.tos.closeEntry();
        }
    }

    public void close() throws IOException {
        this.tos.close();
    }
}

