/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.argius.filetool.compress.Archiver;
import net.argius.filetool.compress.ArchiverEntry;
import net.argius.filetool.compress.LhaArchiver;
import net.argius.filetool.compress.TarArchiver;
import net.argius.filetool.compress.ZipArchiver;

public class CompressTool {
    private final Archiver archiver;

    public CompressTool(File file) throws IOException {
        this(file, ArchiverType.getType(file));
    }

    public CompressTool(File file, ArchiverType archiverType) throws IOException {
        Archiver archiver;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (archiverType == ArchiverType.ZIP) {
            archiver = new ZipArchiver(fileOutputStream);
        } else if (archiverType == ArchiverType.TAR) {
            archiver = new TarArchiver(fileOutputStream);
        } else if (archiverType == ArchiverType.LZH) {
            archiver = new LhaArchiver(fileOutputStream);
        } else {
            throw new IllegalStateException("ArchiverType: " + archiverType);
        }
        this.archiver = archiver;
    }

    public void close() throws IOException {
        this.archiver.close();
    }

    public void archive(File file) throws IOException {
        this.archive(file, CompressTool.getRootPath(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archive(File file, String string) throws IOException {
        boolean bl = file.isDirectory();
        String string2 = CompressTool.getEntryName(file, string, bl);
        ArchiverEntry archiverEntry = new ArchiverEntry(string2);
        archiverEntry.setLastModified(file.lastModified());
        if (bl) {
            this.archiver.addEntry(archiverEntry, null, 0L);
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                this.archive(fileArray[i], string);
            }
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.archiver.addEntry(archiverEntry, fileInputStream, file.length());
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    private static String getRootPath(File file) {
        String string = CompressTool.normalizePath(file.getAbsoluteFile().getParent());
        if (!string.endsWith(String.valueOf('/'))) {
            string = string + '/';
        }
        return string;
    }

    private static String getEntryName(File file, String string, boolean bl) {
        String string2;
        String string3 = CompressTool.normalizePath(file.getAbsolutePath());
        if (string3.startsWith(string)) {
            string2 = string3.substring(string.length());
            if (file.isDirectory() && !string2.endsWith(String.valueOf('/'))) {
                string2 = string2 + '/';
            }
        } else {
            string2 = file.getName();
        }
        return string2;
    }

    private static String normalizePath(String string) {
        return string.replace('\\', '/');
    }

    static class ArchiverType {
        public static final ArchiverType ZIP = new ArchiverType("ZIP");
        public static final ArchiverType TAR = new ArchiverType("TAR");
        public static final ArchiverType LZH = new ArchiverType("LZH");
        public static final ArchiverType UNKNOWN = new ArchiverType("UNKNOWN");
        private String typeName;

        private ArchiverType(String string) {
            this.typeName = string;
        }

        static ArchiverType getType(File file) {
            if (!file.isDirectory()) {
                String string = file.getName().toLowerCase();
                if (string.endsWith(".zip")) {
                    return ZIP;
                }
                if (string.endsWith(".tar")) {
                    return TAR;
                }
                if (string.endsWith(".lzh")) {
                    return LZH;
                }
            }
            return UNKNOWN;
        }

        public String toString() {
            return "ArchiverType:" + this.typeName;
        }
    }
}

