/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import net.argius.filetool.ArchiveEntry;
import net.argius.filetool.Expander;
import net.argius.filetool.IOUtilities;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public final class ZipExpander
implements Expander {
    private ZipFile zfile;
    private Enumeration entries;
    private ZipEntry currentEntry;

    public ZipExpander(File file) throws IOException {
        this.zfile = new ZipFile(file);
        this.entries = this.zfile.getEntries();
    }

    public ArchiveEntry nextEntry() throws IOException {
        if (!this.entries.hasMoreElements()) {
            return ArchiveEntry.EMPTY;
        }
        ZipEntry zipEntry = (ZipEntry)this.entries.nextElement();
        ArchiveEntry archiveEntry = new ArchiveEntry(zipEntry.getName());
        archiveEntry.setLastModified(zipEntry.getTime());
        this.currentEntry = zipEntry;
        return archiveEntry;
    }

    public long expand(OutputStream outputStream) throws IOException {
        return IOUtilities.transferAll(this.zfile.getInputStream(this.currentEntry), outputStream);
    }

    public void close() throws IOException {
        this.zfile.close();
    }
}

