/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtilities {
    private static int bufferSize = 8192;

    private IOUtilities() {
    }

    public static void setBufferSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("invalid size: " + n);
        }
        bufferSize = n;
    }

    public static boolean move(File file, File file2, boolean bl) throws IOException {
        if (file2.exists()) {
            if (bl) {
                file2.delete();
            } else {
                throw new IOException("file already exists: " + file2);
            }
        }
        IOUtilities.mkdirsIfNotExists(file2);
        return file.renameTo(file2);
    }

    public static void copy(File file, File file2, boolean bl) throws IOException {
        if (file2.exists() && !bl) {
            throw new IOException("file already exists: " + file2);
        }
        IOUtilities.copy(file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File file, File file2) throws IOException {
        long l = file.lastModified();
        IOUtilities.mkdirsIfNotExists(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            long l2;
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                long l3 = IOUtilities.transferAll(fileInputStream, fileOutputStream);
                file2.setLastModified(l);
                l2 = l3;
            }
            catch (Throwable throwable) {
                fileInputStream.close();
                throw throwable;
            }
            fileInputStream.close();
            return l2;
        }
        finally {
            fileOutputStream.close();
        }
    }

    public static long transfer(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        int n;
        int n2;
        long l2 = l;
        long l3 = 0L;
        int n3 = bufferSize;
        byte[] byArray = new byte[n3];
        while (l2 > 0L && (n2 = inputStream.read(byArray, 0, n = Math.min((int)l2, n3))) >= 0) {
            outputStream.write(byArray, 0, n2);
            l2 -= (long)n2;
            l3 += (long)n2;
        }
        outputStream.flush();
        return l3;
    }

    public static long transferAll(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[bufferSize];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        outputStream.flush();
        return l;
    }

    private static void mkdirsIfNotExists(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists() && !file2.mkdirs()) {
            throw new IOException("failed to mkdir: " + file2);
        }
    }
}

