/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import net.argius.filetool.Bzip2Compressor;
import net.argius.filetool.CompressType;
import net.argius.filetool.GzipCompressor;
import net.argius.filetool.IOUtilities;
import net.argius.filetool.Utilities;

public final class FileCompressor {
    static /* synthetic */ Class class$net$argius$filetool$DiskUsage;

    public static void compress(File file, CompressType compressType) throws IOException {
        File file2;
        if (compressType == CompressType.GZIP) {
            file2 = new File(file.getParentFile(), file.getName() + ".gz");
        } else if (compressType == CompressType.BZIP2) {
            file2 = new File(file.getParentFile(), file.getName() + ".bz2");
        } else {
            throw new IllegalArgumentException();
        }
        FileCompressor.compress(file, file2, compressType);
    }

    public static void compress(File file, File file2) throws IOException {
        FileCompressor.compress(file, file2, CompressType.getType(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(File file, File file2, CompressType compressType) throws IOException {
        OutputStream outputStream;
        File file3 = Utilities.createTemporaryFile();
        if (compressType == CompressType.GZIP) {
            outputStream = new GzipCompressor(new FileOutputStream(file3));
        } else if (compressType == CompressType.BZIP2) {
            outputStream = new Bzip2Compressor(new FileOutputStream(file3));
        } else {
            throw new IllegalArgumentException();
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                outputStream.compress(fileInputStream);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        finally {
            outputStream.close();
        }
        IOUtilities.move(file3, file2, false);
    }

    private static void printUsage() {
        PrintStream printStream = System.err;
        printStream.println("FileCompressor (argius-filetool)");
        printStream.println("usage : (command) src dst");
        printStream.println("options: none");
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length < 2) {
            FileCompressor.printUsage();
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals("-h") && !string.equals("--help")) continue;
            FileCompressor.printUsage();
            return;
        }
        try {
            FileCompressor.compress(new File(stringArray[0]), new File(stringArray[1]));
            n = 0;
        }
        catch (IOException iOException) {
            System.out.println("FileCompressor: " + iOException.getMessage());
            n = 1;
        }
        catch (Exception exception) {
            String string = exception + Utilities.getFirstStackTrace(exception, class$net$argius$filetool$DiskUsage == null ? (class$net$argius$filetool$DiskUsage = FileCompressor.class$("net.argius.filetool.DiskUsage")) : class$net$argius$filetool$DiskUsage);
            System.out.println("FileCompressor: " + string);
            n = 255;
        }
        if (n > 0) {
            System.exit(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

