/*
 * Decompiled with CFR 0.152.
 */
package net.argius.filetool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import net.argius.filetool.ArchiveEntry;
import net.argius.filetool.ArchiveType;
import net.argius.filetool.Archiver;
import net.argius.filetool.Bzip2Compressor;
import net.argius.filetool.GzipCompressor;
import net.argius.filetool.LhaArchiver;
import net.argius.filetool.TarArchiver;
import net.argius.filetool.Utilities;
import net.argius.filetool.ZipArchiver;

public final class FileArchiver {
    private Archiver archiver;
    static /* synthetic */ Class class$net$argius$filetool$DiskUsage;

    public FileArchiver(File file) throws IOException {
        this(file, ArchiveType.getType(file));
    }

    public FileArchiver(File file, ArchiveType archiveType) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (archiveType == ArchiveType.TAR) {
            this.archiver = new TarArchiver(fileOutputStream);
        } else if (archiveType == ArchiveType.TGZ) {
            this.archiver = new TarArchiver(new GzipCompressor(fileOutputStream));
        } else if (archiveType == ArchiveType.TBZ) {
            this.archiver = new TarArchiver(new Bzip2Compressor(fileOutputStream));
        } else if (archiveType == ArchiveType.ZIP) {
            this.archiver = new ZipArchiver(fileOutputStream);
        } else if (archiveType == ArchiveType.LZH) {
            this.archiver = new LhaArchiver(fileOutputStream);
        } else {
            throw new IllegalStateException("ArchiverType: " + archiveType);
        }
    }

    public void close() throws IOException {
        this.archiver.close();
    }

    public void archive(File file) throws IOException {
        this.archive(file, FileArchiver.getRootPath(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archive(File file, String string) throws IOException {
        boolean bl = file.isDirectory();
        String string2 = FileArchiver.getEntryName(file, string, bl);
        ArchiveEntry archiveEntry = new ArchiveEntry(string2);
        archiveEntry.setLastModified(file.lastModified());
        if (bl) {
            this.archiver.addEntry(archiveEntry, null, 0L);
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                this.archive(fileArray[i], string);
            }
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.archiver.addEntry(archiveEntry, fileInputStream, file.length());
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    private static String getRootPath(File file) {
        String string = FileArchiver.normalizePath(file.getAbsoluteFile().getParent());
        if (!string.endsWith(String.valueOf('/'))) {
            string = string + '/';
        }
        return string;
    }

    private static String getEntryName(File file, String string, boolean bl) {
        String string2;
        String string3 = FileArchiver.normalizePath(file.getAbsolutePath());
        if (string3.startsWith(string)) {
            string2 = string3.substring(string.length());
            if (file.isDirectory() && !string2.endsWith(String.valueOf('/'))) {
                string2 = string2 + '/';
            }
        } else {
            string2 = file.getName();
        }
        return string2;
    }

    private static String normalizePath(String string) {
        return string.replace('\\', '/');
    }

    private static void printUsage() {
        PrintStream printStream = System.err;
        printStream.println("FileArchiver (argius-filetool)");
        printStream.println("usage : (command) dst src...");
        printStream.println("options: none");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length < 2) {
            FileArchiver.printUsage();
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals("-h") && !string.equals("--help")) continue;
            FileArchiver.printUsage();
            return;
        }
        try {
            File file = new File(stringArray[0]);
            FileArchiver fileArchiver = new FileArchiver(file);
            try {
                for (int i = 1; i < stringArray.length; ++i) {
                    fileArchiver.archive(new File(stringArray[i]));
                }
            }
            finally {
                fileArchiver.close();
            }
            n = 0;
        }
        catch (IOException iOException) {
            System.out.println("FileArchiver: " + iOException.getMessage());
            n = 1;
        }
        catch (Exception exception) {
            String string = exception + Utilities.getFirstStackTrace(exception, class$net$argius$filetool$DiskUsage == null ? (class$net$argius$filetool$DiskUsage = FileArchiver.class$("net.argius.filetool.DiskUsage")) : class$net$argius$filetool$DiskUsage);
            System.out.println("FileArchiver: " + string);
            n = 255;
        }
        if (n > 0) {
            System.exit(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

