package net.argius.calendar;

import static java.lang.Integer.parseInt;
import static javax.swing.JOptionPane.*;
import static net.argius.calendar.Resource.*;

import java.awt.*;
import java.awt.event.*;
import java.text.*;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.event.*;

/**
 * EBhE\B
 */
public final class WindowView extends JFrame {

    private static final Color BG_COLOR = new Color(255, 255, 248);

    static List<WindowView> instances = new ArrayList<WindowView>();

    private final MainPanel panel;

    /**
     * MainWindow̐B
     */
    public WindowView() {
        instances.add(this);
        setTitle(getString("main.title"));
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        setIconImage(getImage("icon.gif"));
        this.panel = new MainPanel();
        panel.setOpaque(true);
        panel.setBackground(BG_COLOR);
        add(panel);
        panel.onWindowResized(null);
        Menu menu = new Menu(this);
        setJMenuBar(menu);
        menu.addMenuListener(new MenuListener() {

            public void menuSelected(MenuEvent e) {
                Object src = e.getSource();
                if (src instanceof Menu.Item) {
                    Menu.Item key = (Menu.Item)src;
                    onMenuSelected(key);
                }
            }

            public void menuDeselected(MenuEvent e) {
                System.err.println(e);
            }

            public void menuCanceled(MenuEvent e) {
                System.err.println(e);
            }

        });
        addWindowListener(new WindowAdapter() {

            @Override
            public void windowClosing(WindowEvent e) {
                requestClose();
            }

        });
        MouseWheelListener mouseWheelListener = new MouseWheelListener() {

            public void mouseWheelMoved(MouseWheelEvent e) {
                processMouseWheelEvent(e);
            }

        };
        getContentPane().addMouseWheelListener(mouseWheelListener);
        boolean windowAlwaysOntop = LocalProperty.getBooleanProperty("window.alwaysontop");
        menu.cAlwaysOnTop.setSelected(windowAlwaysOntop);
        try {
            switchAlwaysOnTopState();
        } catch (SecurityException ex) {
            // ignore
        }
        refresh();
        if (!LocalProperty.errorList.isEmpty()) {
            for (Throwable th : LocalProperty.errorList) {
                ErrorDialog.show(this, th);
            }
        }
    }

    /* @see java.awt.Component#processMouseWheelEvent(java.awt.event.MouseWheelEvent) */
    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        int amount = e.getWheelRotation();
        rotateCalendar(amount, e.isControlDown());
    }

    /**
     * B
     * @return ꂽWindowView
     */
    public WindowView duplicate() {
        WindowView o = new WindowView();
        o.setSize(getSize());
        o.panel.calendar.setTime(panel.calendar.getTime());
        o.refresh();
        return o;
    }

    /**
     * ĕ`悷B
     * J_[̏Ԃɏ]ďB
     */
    private void refresh() {
        panel.refresh();
    }

    /**
     * SẴEBhEĕ`悷B
     */
    private void refreshAll() {
        for (WindowView instance : instances) {
            instance.refresh();
        }
    }

    /**
     * J_[[e[gB
     * @param amount [e[g(͖A͉ߋ)
     * @param isControlDown Rg[L[Ăꍇ <code>true</code>
     *                      łȂꍇ <code>false</code>
     */
    void rotateCalendar(int amount, boolean isControlDown) {
        panel.rotateCalendar(amount, isControlDown);
    }

    /**
     * ɃWvB
     */
    private void jumpToToday() {
        panel.jumpToToday();
    }

    /**
     * j[I̓B
     * @param item j[
     */
    void onMenuSelected(Menu.Item item) {
        assert Thread.currentThread().getName().equals("AWT-EventQueue-0");
        switch (item) {
            case NEW:
                for (WindowView instance : instances) {
                    if (instance.isActive()) {
                        int d = 10;
                        JFrame f = duplicate();
                        f.setLocation(instance.getX() + d, instance.getY() + d);
                        f.setVisible(true);
                        break;
                    }
                }
                break;
            case ANNUAL:
                showAnnualcalendar();
                break;
            case CLOSE:
                requestClose();
                break;
            case EXIT:
                confirmExit();
                break;
            case TODAY:
                jumpToToday();
                break;
            case PREV_MONTH:
                rotateCalendar(-1, false);
                break;
            case NEXT_MONTH:
                rotateCalendar(+1, false);
                break;
            case PREV_YEAR:
                rotateCalendar(-12, false);
                break;
            case NEXT_YEAR:
                rotateCalendar(+12, false);
                break;
            case ALIGNMENT:
                alignWindows();
                break;
            case ALWAYS_ON_TOP:
                try {
                    switchAlwaysOnTopState();
                } catch (SecurityException ex) {
                    ErrorDialog.show(this, ex);
                }
                break;
            case COLOR:
                changeColor();
                break;
            case HELP:
                Action action = new HelpAction(this);
                action.actionPerformed(new ActionEvent(this, 1, item.getString()));
                break;
            case ABOUT:
                showVersionInfo();
                break;
            default:
                ErrorDialog.show(this, new IllegalStateException("menu: " + item));
        }
    }

    /**
     * NԃJ_[\B
     */
    private void showAnnualcalendar() {
        int year = panel.calendar.get(Calendar.YEAR);
        WindowView w = duplicate();
        JPanel p = new JPanel(new GridLayout(4, 3));
        p.setOpaque(true);
        p.setBackground(BG_COLOR);
        for (int i = 0; i < 12; i++) {
            MainPanel mp = new MainPanel();
            mp.calendar.set(year, i, 1);
            final float fontSize = mp.fontSize;
            JPanel child = new JPanel(new BorderLayout());
            child.setOpaque(false);
            child.setBorder(BorderFactory.createLineBorder(Color.GRAY.brighter()));
            final CalendarPanel cp = new CalendarPanel(mp.calendar, fontSize);
            cp.setOpaque(false);
            JLabel monthLabel = mp.createMonthLabel();
            monthLabel.addComponentListener(new ComponentAdapter() {

                @Override
                public void componentResized(ComponentEvent e) {
                    Component c = e.getComponent();
                    float fontSize = cp.getFont().getSize();
                    Font font = c.getFont();
                    c.setFont(font.deriveFont(fontSize));
                }

            });
            child.add(cp, BorderLayout.CENTER);
            child.add(monthLabel, BorderLayout.SOUTH);
            p.add(child);
        }
        w.add(p);
        w.setExtendedState(Frame.MAXIMIZED_BOTH);
        w.validate();
        w.setVisible(true);
    }

    /**
     * ׂẴEBhE𐮗񂷂B
     */
    private void alignWindows() {
        int count = instances.size();
        if (count < 2) {
            setLocation(0, 0);
            return;
        }
        int denominatorX = 1;
        int denominatorY = 1;
        while (denominatorX * denominatorY < count) {
            if (denominatorX >= denominatorY) {
                ++denominatorY;
            } else {
                ++denominatorX;
            }
        }
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int width = d.width / denominatorX;
        int height = d.height / denominatorY - 16;
        int x = 0;
        int y = 0;
        for (WindowView w : instances) {
            w.setBounds(x, y, width, height);
            w.requestFocus();
            w.validate();
            x += width;
            if (x + width > d.width) {
                x = 0;
                y += height;
                if (y + height > d.height) {
                    break;
                }
            }
        }
        requestFocus();
    }

    /**
     * "ɎOɕ\"Ԃ؂ւB
     */
    private void switchAlwaysOnTopState() {
        Menu menu = (Menu)getJMenuBar();
        setAlwaysOnTop(menu.cAlwaysOnTop.getState());
    }

    /**
     * F̕ύXB
     */
    private void changeColor() {
        Color color = JColorChooser.showDialog(this, "", Color.WHITE);
        if (color != null) {
            String colorString = String.format("#%02X%02X%02X",
                                               color.getRed(),
                                               color.getGreen(),
                                               color.getBlue());
            LocalProperty.setProperty("color.holiday", colorString);
            refreshAll();
        }
    }

    /**
     * o[W\B
     */
    void showVersionInfo() {
        String msg = MessageFormat.format(getString("main.about"), Resource.getVersion());
        showMessageDialog(this, msg, EMPTY_STRING, 0, new ImageIcon(getIconImage()));
    }

    /**
     * 鏈vB
     */
    void requestClose() {
        assert instances.size() > 0;
        if (instances.size() == 1) {
            confirmExit();
        } else {
            instances.remove(WindowView.this);
            dispose();
        }
    }

    /**
     * ImFvB
     */
    void confirmExit() {
        String message = getString(".confirmquit");
        if (showConfirmDialog(WindowView.this, message, "", YES_NO_OPTION) == OK_OPTION) {
            exit();
        }
    }

    /**
     * IsB
     */
    private void exit() {
        for (WindowView instance : instances) {
            instance.dispose();
        }
        instances.clear();
    }

    /**
     * Gg|CgB
     * @param args p[^
     */
    public static void main(String... args) {
        // parse options
        boolean errorOccurred = false;
        Dimension size = null;
        Point location = null;
        final String opSize = "--size=";
        final String opLocation = "--location=";
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (arg.startsWith(opSize)) {
                    String[] a = arg.substring(opSize.length()).split(",");
                    if (a.length != 2) {
                        errorOccurred = true;
                    }
                    size = new Dimension(parseInt(a[0]), parseInt(a[1]));
                } else if (arg.startsWith(opLocation)) {
                    String[] a = arg.substring(opLocation.length()).split(",");
                    if (a.length != 2) {
                        errorOccurred = true;
                    }
                    location = new Point(parseInt(a[0]), parseInt(a[1]));
                } else if (arg.startsWith("--gui")) {
                    continue;
                } else {
                    errorOccurred = true;
                }
            }
            if (errorOccurred) {
                throw new IllegalArgumentException("bad option: " + arg);
            }
        }
        // main
        final Dimension windowSize;
        if (size == null) {
            windowSize = new Dimension(400, 300);
        } else {
            windowSize = size;
        }
        final Point windowLocation = location;
        EventQueue.invokeLater(new Runnable() {

            public void run() {
                MonospacedFontLookAndFeel.install();
                JFrame f = new WindowView();
                f.setSize(windowSize);
                if (windowLocation == null) {
                    f.setLocationRelativeTo(null);
                } else {
                    f.setLocation(windowLocation);
                }
                f.setVisible(true);
            }

        });
    }

}
