package net.argius.calendar;

import static java.util.Calendar.*;
import static javax.swing.JOptionPane.*;
import static net.argius.calendar.Resource.DEFAULT_FONT_SIZE;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.util.List;

import javax.swing.*;

/**
 * CplB
 */
public final class MainPanel extends JPanel {

    final Calendar calendar;

    float fontSize;

    /**
     * MainPanel̐B
     */
    public MainPanel() {
        this.calendar = Calendar.getInstance();
        this.fontSize = DEFAULT_FONT_SIZE;
        calendar.set(DAY_OF_MONTH, 1);
        calendar.set(HOUR_OF_DAY, 12);

        setLayout(new BorderLayout());
        addComponentListener(new ComponentAdapter() {

            @Override
            public void componentResized(ComponentEvent e) {
                onWindowResized(e);
            }
        });
        refresh();
    }

    /* @see java.awt.Component#processMouseWheelEvent(java.awt.event.MouseWheelEvent) */
    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        int amount = e.getWheelRotation();
        rotateCalendar(amount, e.isControlDown());
    }

    /**
     * ĕ`悷B
     * J_[̏Ԃɏ]ďB
     */
    void refresh() {
        removeAll();
        CalendarPanel cp = new CalendarPanel(calendar, fontSize);
        cp.setOpaque(false);
        for (Component c : getAllComponents(cp)) {
            c.setFont(c.getFont().deriveFont(fontSize));
        }
        add(cp, BorderLayout.CENTER);
        add(createControlPanel(), BorderLayout.SOUTH);
        validate();
        requestFocus();
    }

    /**
     * ReîׂẴR|[lg擾B
     * Container.getComponents()ł͎擾łȂ߁B
     * @param container Rei
     * @return SR|[lg
     */
    private static List<Component> getAllComponents(Container container) {
        List<Component> list = new ArrayList<Component>();
        for (Component c : container.getComponents()) {
            list.add(c);
            if (c instanceof Container) {
                list.addAll(getAllComponents((Container)c));
            }
        }
        return list;
    }

    /**
     * J_[[e[gB
     * @param amount [e[g(͖A͉ߋ)
     * @param isControlDown Rg[L[Ăꍇ <code>true</code>
     *                      łȂꍇ <code>false</code>
     */
    void rotateCalendar(int amount, boolean isControlDown) {
        if (isControlDown) {
            amount *= 12;
        }
        calendar.add(MONTH, amount);
        refresh();
    }

    /**
     * ɃWvB
     */
    void jumpToToday() {
        Calendar now = Calendar.getInstance();
        calendar.set(YEAR, now.get(YEAR));
        calendar.set(MONTH, now.get(MONTH));
        refresh();
    }

    /**
     * Rg[pl̐B
     * @return Rg[pl
     */
    private JPanel createControlPanel() {
        JPanel left = new JPanel(new GridLayout(1, 2));
        left.add(createJButton("RR.gif", new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                rotateCalendar(-12, false);
            }

        }));
        left.add(createJButton("R.gif", new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                rotateCalendar(-1, false);
            }

        }));
        JPanel right = new JPanel(new GridLayout(1, 2));
        right.add(createJButton("F.gif", new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                rotateCalendar(+1, false);
            }

        }));
        right.add(createJButton("FF.gif", new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                rotateCalendar(+12, false);
            }

        }));
        JLabel center = createMonthLabel();
        center.addMouseListener(new MouseAdapter() {

            @Override
            public void mousePressed(MouseEvent arg0) {
                confirmSpecificMonth();
            }

        });
        JPanel p = new JPanel(new BorderLayout());
        p.add(left, BorderLayout.WEST);
        p.add(center, BorderLayout.CENTER);
        p.add(right, BorderLayout.EAST);
        p.setOpaque(false);
        return p;
    }

    /**
     * Nx̐B
     * @return Nx
     */
    JLabel createMonthLabel() {
        String format = Resource.getString("pane.monthformat");
        String labelString = String.format(format, calendar);
        JLabel center = new JLabel(labelString);
        center.setFont(center.getFont().deriveFont(fontSize));
        center.setHorizontalAlignment(SwingConstants.CENTER);
        center.setOpaque(false);
        return center;
    }

    /**
     * N𒼐ڎw肵ĈړB
     */
    void confirmSpecificMonth() {
        SpinnerNumberModel y = new SpinnerNumberModel(calendar.get(YEAR), 1, 9999, 1);
        SpinnerNumberModel m = new SpinnerNumberModel(calendar.get(MONTH) + 1, 1, 12, 1);
        JPanel p = new JPanel(new FlowLayout());
        JSpinner yearSpinner = new JSpinner(y);
        yearSpinner.setEditor(new JSpinner.NumberEditor(yearSpinner, "0"));
        p.add(yearSpinner);
        p.add(new JSpinner(m));
        if (JOptionPane.showConfirmDialog(this, p, "", OK_CANCEL_OPTION, INFORMATION_MESSAGE) == OK_OPTION) {
            calendar.set(YEAR, y.getNumber().intValue());
            calendar.set(MONTH, m.getNumber().intValue() - 1);
            refresh();
        }
    }

    /**
     * JButton̐B
     * @param name ACR\[X
     * @param action ANV
     * @return JButton
     */
    private static JButton createJButton(String name, Action action) {
        Image imageFromResource = Resource.getImage(name);
        Image resized = imageFromResource.getScaledInstance(20, 8, 0);
        JButton button = new JButton(new ImageIcon(resized));
        button.setFont(button.getFont().deriveFont(9f));
        button.addActionListener(action);
        //        button.setRequestFocusEnabled(true);
        return button;
    }

    /**
     * EBhETCY̏B
     * @param e ComponentEvent
     */
    void onWindowResized(ComponentEvent e) {
        float rate = Math.min(getWidth() / 640f, getHeight() / 480f);
        fontSize = DEFAULT_FONT_SIZE * rate;
        refresh();
    }

}
