package net.argius.calendar;

import java.awt.*;
import java.awt.event.*;
import java.io.*;

import javax.swing.*;

/**
 * G[_CAOB
 */
final class ErrorDialog {

    /**
     * G[\B
     * @param parent eRei
     * @param error G[
     */
    static void show(final Container parent, final Throwable error) {
        JPanel p = new JPanel();
        p.add(new JLabel(error.getMessage()));
        JButton b = new JButton(Resource.getString(".detail"));
        b.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                Writer buffer = new StringWriter();
                PrintWriter out = new PrintWriter(buffer);
                error.printStackTrace(out);
                JEditorPane editor = new JEditorPane("text/plain", buffer.toString());
                editor.setEditable(false);
                final JScrollPane sp = new JScrollPane(editor);
                sp.setAutoscrolls(false);
                JOptionPane pane = new JOptionPane(sp,
                                                   JOptionPane.PLAIN_MESSAGE,
                                                   JOptionPane.DEFAULT_OPTION);
                EventQueue.invokeLater(new Runnable() {

                    public void run() {
                        // ̏uŐH
                        sp.getVerticalScrollBar().setValue(0);
                    }

                });
                JDialog dialog = pane.createDialog(parent, "");
                dialog.setResizable(true);
                dialog.setLocation(parent.getX() + 10, parent.getY() + 10);
                dialog.setSize(360, 240);
                dialog.setVisible(true);
            }

        });
        p.add(b);
        JOptionPane pane = new JOptionPane(p);
        JDialog dialog = pane.createDialog(parent, "ERROR");
        dialog.setVisible(true);
    }

}
