package net.argius.calendar;

import java.text.*;
import java.util.*;

import junit.framework.*;

/**
 * 
 */
public class HolidayTest extends TestCase {

    //    private Holiday1 oldImpl;
    private Holiday newImpl;

    /* @see junit.framework.TestCase#setUp() */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        //        this.oldImpl = new Holiday1();
        this.newImpl = Holiday.getInstance();
    }

    /**
     * j@̃eXgB
     */
    public void testOldHoliday() {
        checkOldHoliday(1873, 1, 3, "n");
        checkOldHoliday(1874, 1, 5, "VN");
        checkOldHoliday(1899, 7, 30, "");
        checkOldHoliday(1912, 7, 30, "Vc");
        checkOldHoliday(1927, 7, 30, "");
        checkOldHoliday(1878, 9, 17, "_");
        checkOldHoliday(1879, 10, 17, "_");
        checkOldHoliday(1911, 11, 3, "V");
        checkOldHoliday(1912, 8, 31, "V");
        checkOldHoliday(1927, 4, 29, "V");
    }

    /**
     * sj@̃eXgB
     */
    public void testCurrentHoliday() {
        checkHoliday(1948, 1, 1, "");
        checkHoliday(1949, 1, 1, "U");
        checkHoliday(1948, 1, 15, "");
        checkHoliday(1949, 1, 15, "l̓");
        checkHoliday(2000, 1, 10, "l̓inbs[}f[j");
        checkHoliday(1966, 2, 11, "");
        checkHoliday(1967, 2, 11, "LO̓");
        checkHoliday(1868, 3, 21, "t (jH)");
        checkHoliday(1985, 5, 4, "");
        checkHoliday(1986, 5, 4, ""); // j
        checkHoliday(1987, 5, 4, "U֋xi@LOj");
        checkHoliday(2006, 5, 4, "̋x");
        checkHoliday(2007, 5, 4, "݂ǂ̓");
        checkHoliday(2008, 5, 6, "U֋x");
        checkHoliday(1868, 9, 24, "H (jH)");
        checkHoliday(2009, 9, 22, "̋x");
        checkHoliday(2007, 12, 24, "U֋xiVcaj");
        checkHoliday(1868, 12, 31, "");
    }

    /**
     * @param year
     * @param month
     * @param day
     * @param expect zl
     */
    private void checkHoliday(int year, int month, int day, String expect) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(year, month - 1, day);
        String msg = "calendar=" + new SimpleDateFormat("yyyy/MM/dd").format(c.getTime());
        //        Day1 d1 = oldImpl.getDay(c);
        //        String oldImplHolidayName = d1.getHolidayName();
        //        if (!oldImplHolidayName.equals("U֋x")) {
        //            assertEquals(msg, expect, oldImplHolidayName);
        //        }
        assertEquals(msg, expect, newImpl.getHolidayName(year, month, day));
    }

    /**
     * @param year 
     * @param month
     * @param day
     * @param expect zl
     */
    private void checkOldHoliday(int year, int month, int day, String expect) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(year, month - 1, day);
        String msg = "calendar=" + c.getTime();
        assertEquals(msg, expect, newImpl.getHolidayName(year, month, day));
    }

}
