/*
 * Decompiled with CFR 0.152.
 */
package net.argius.calendar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.argius.calendar.CalendarPanel;
import net.argius.calendar.ErrorDialog;
import net.argius.calendar.HelpAction;
import net.argius.calendar.LocalProperty;
import net.argius.calendar.MainPanel;
import net.argius.calendar.Menu;
import net.argius.calendar.MonospacedFontLookAndFeel;
import net.argius.calendar.Resource;

public final class WindowView
extends JFrame {
    private static final Color BG_COLOR = new Color(255, 255, 248);
    static List<WindowView> instances = new ArrayList<WindowView>();
    private final MainPanel panel;

    public WindowView() {
        instances.add(this);
        this.setTitle(Resource.getString("main.title"));
        this.setDefaultCloseOperation(0);
        this.setIconImage(Resource.getImage("icon.gif"));
        this.panel = new MainPanel();
        this.panel.setOpaque(true);
        this.panel.setBackground(BG_COLOR);
        this.add(this.panel);
        this.panel.onWindowResized(null);
        Menu menu = new Menu(this);
        this.setJMenuBar(menu);
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                Object object = menuEvent.getSource();
                if (object instanceof Menu.Item) {
                    Menu.Item item = (Menu.Item)((Object)object);
                    WindowView.this.onMenuSelected(item);
                }
            }

            public void menuDeselected(MenuEvent menuEvent) {
                System.err.println(menuEvent);
            }

            public void menuCanceled(MenuEvent menuEvent) {
                System.err.println(menuEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                WindowView.this.requestClose();
            }
        });
        MouseWheelListener mouseWheelListener = new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                WindowView.this.processMouseWheelEvent(mouseWheelEvent);
            }
        };
        this.getContentPane().addMouseWheelListener(mouseWheelListener);
        boolean bl = LocalProperty.getBooleanProperty("window.alwaysontop");
        menu.cAlwaysOnTop.setSelected(bl);
        try {
            this.switchAlwaysOnTopState();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.refresh();
        if (!LocalProperty.errorList.isEmpty()) {
            for (Throwable throwable : LocalProperty.errorList) {
                ErrorDialog.show(this, throwable);
            }
        }
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        this.rotateCalendar(n, mouseWheelEvent.isControlDown());
    }

    public WindowView duplicate() {
        WindowView windowView = new WindowView();
        windowView.setSize(this.getSize());
        windowView.panel.calendar.setTime(this.panel.calendar.getTime());
        windowView.refresh();
        return windowView;
    }

    private void refresh() {
        this.panel.refresh();
    }

    private void refreshAll() {
        for (WindowView windowView : instances) {
            windowView.refresh();
        }
    }

    void rotateCalendar(int n, boolean bl) {
        this.panel.rotateCalendar(n, bl);
    }

    private void jumpToToday() {
        this.panel.jumpToToday();
    }

    void onMenuSelected(Menu.Item item) {
        assert (Thread.currentThread().getName().equals("AWT-EventQueue-0"));
        block1 : switch (item) {
            case NEW: {
                for (WindowView windowView : instances) {
                    if (!windowView.isActive()) continue;
                    int n = 10;
                    WindowView windowView2 = this.duplicate();
                    windowView2.setLocation(windowView.getX() + n, windowView.getY() + n);
                    windowView2.setVisible(true);
                    break block1;
                }
                break;
            }
            case ANNUAL: {
                this.showAnnualcalendar();
                break;
            }
            case CLOSE: {
                this.requestClose();
                break;
            }
            case EXIT: {
                this.confirmExit();
                break;
            }
            case TODAY: {
                this.jumpToToday();
                break;
            }
            case PREV_MONTH: {
                this.rotateCalendar(-1, false);
                break;
            }
            case NEXT_MONTH: {
                this.rotateCalendar(1, false);
                break;
            }
            case PREV_YEAR: {
                this.rotateCalendar(-12, false);
                break;
            }
            case NEXT_YEAR: {
                this.rotateCalendar(12, false);
                break;
            }
            case ALIGNMENT: {
                this.alignWindows();
                break;
            }
            case ALWAYS_ON_TOP: {
                try {
                    this.switchAlwaysOnTopState();
                }
                catch (SecurityException securityException) {
                    ErrorDialog.show(this, securityException);
                }
                break;
            }
            case COLOR: {
                this.changeColor();
                break;
            }
            case HELP: {
                HelpAction helpAction = new HelpAction(this);
                helpAction.actionPerformed(new ActionEvent(this, 1, item.getString()));
                break;
            }
            case ABOUT: {
                this.showVersionInfo();
                break;
            }
            default: {
                ErrorDialog.show(this, new IllegalStateException("menu: " + (Object)((Object)item)));
            }
        }
    }

    private void showAnnualcalendar() {
        int n = this.panel.calendar.get(1);
        WindowView windowView = this.duplicate();
        JPanel jPanel = new JPanel(new GridLayout(4, 3));
        jPanel.setOpaque(true);
        jPanel.setBackground(BG_COLOR);
        for (int i = 0; i < 12; ++i) {
            MainPanel mainPanel = new MainPanel();
            mainPanel.calendar.set(n, i, 1);
            float f = mainPanel.fontSize;
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setOpaque(false);
            jPanel2.setBorder(BorderFactory.createLineBorder(Color.GRAY.brighter()));
            final CalendarPanel calendarPanel = new CalendarPanel(mainPanel.calendar, f);
            calendarPanel.setOpaque(false);
            JLabel jLabel = mainPanel.createMonthLabel();
            jLabel.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    Component component = componentEvent.getComponent();
                    float f = calendarPanel.getFont().getSize();
                    Font font = component.getFont();
                    component.setFont(font.deriveFont(f));
                }
            });
            jPanel2.add((Component)calendarPanel, "Center");
            jPanel2.add((Component)jLabel, "South");
            jPanel.add(jPanel2);
        }
        windowView.add(jPanel);
        windowView.setExtendedState(6);
        windowView.validate();
        windowView.setVisible(true);
    }

    private void alignWindows() {
        int n = instances.size();
        if (n < 2) {
            this.setLocation(0, 0);
            return;
        }
        int n2 = 1;
        int n3 = 1;
        while (n2 * n3 < n) {
            if (n2 >= n3) {
                ++n3;
                continue;
            }
            ++n2;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n4 = dimension.width / n2;
        int n5 = dimension.height / n3 - 16;
        int n6 = 0;
        int n7 = 0;
        for (WindowView windowView : instances) {
            windowView.setBounds(n6, n7, n4, n5);
            windowView.requestFocus();
            windowView.validate();
            if ((n6 += n4) + n4 <= dimension.width) continue;
            n6 = 0;
            if ((n7 += n5) + n5 <= dimension.height) continue;
            break;
        }
        this.requestFocus();
    }

    private void switchAlwaysOnTopState() {
        Menu menu = (Menu)this.getJMenuBar();
        this.setAlwaysOnTop(menu.cAlwaysOnTop.getState());
    }

    private void changeColor() {
        Color color = JColorChooser.showDialog(this, "", Color.WHITE);
        if (color != null) {
            String string = String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
            LocalProperty.setProperty("color.holiday", string);
            this.refreshAll();
        }
    }

    void showVersionInfo() {
        String string = MessageFormat.format(Resource.getString("main.about"), Resource.getVersion());
        JOptionPane.showMessageDialog(this, string, "", 0, new ImageIcon(this.getIconImage()));
    }

    void requestClose() {
        assert (instances.size() > 0);
        if (instances.size() == 1) {
            this.confirmExit();
        } else {
            instances.remove(this);
            this.dispose();
        }
    }

    void confirmExit() {
        String string = Resource.getString(".confirmquit");
        if (JOptionPane.showConfirmDialog(this, string, "", 0) == 0) {
            this.exit();
        }
    }

    private void exit() {
        for (WindowView windowView : instances) {
            windowView.dispose();
        }
        instances.clear();
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String ... stringArray) {
        void var6_7;
        boolean bl = false;
        Dimension dimension = null;
        Point point = null;
        for (String string : stringArray) {
            if (string.startsWith("-")) {
                String[] stringArray2;
                if (string.startsWith("--size=")) {
                    stringArray2 = string.substring("--size=".length()).split(",");
                    if (stringArray2.length != 2) {
                        bl = true;
                    }
                    dimension = new Dimension(Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray2[1]));
                } else if (string.startsWith("--location=")) {
                    stringArray2 = string.substring("--location=".length()).split(",");
                    if (stringArray2.length != 2) {
                        bl = true;
                    }
                    point = new Point(Integer.parseInt(stringArray2[0]), Integer.parseInt(stringArray2[1]));
                } else {
                    if (string.startsWith("--gui")) continue;
                    bl = true;
                }
            }
            if (!bl) continue;
            throw new IllegalArgumentException("bad option: " + string);
        }
        if (dimension == null) {
            Dimension dimension2 = new Dimension(400, 300);
        } else {
            Dimension dimension3 = dimension;
        }
        Point point2 = point;
        EventQueue.invokeLater(new Runnable((Dimension)var6_7, point2){
            final /* synthetic */ Dimension val$windowSize;
            final /* synthetic */ Point val$windowLocation;
            {
                this.val$windowSize = dimension;
                this.val$windowLocation = point;
            }

            public void run() {
                MonospacedFontLookAndFeel.install();
                WindowView windowView = new WindowView();
                windowView.setSize(this.val$windowSize);
                if (this.val$windowLocation == null) {
                    windowView.setLocationRelativeTo(null);
                } else {
                    windowView.setLocation(this.val$windowLocation);
                }
                windowView.setVisible(true);
            }
        });
    }
}

