/*
 * Decompiled with CFR 0.152.
 */
package net.argius.calendar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.argius.calendar.CalendarPanel;
import net.argius.calendar.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MainPanel
extends JPanel {
    final Calendar calendar = Calendar.getInstance();
    float fontSize = 24.0f;

    public MainPanel() {
        this.calendar.set(5, 1);
        this.calendar.set(11, 12);
        this.setLayout(new BorderLayout());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MainPanel.this.onWindowResized(componentEvent);
            }
        });
        this.refresh();
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        this.rotateCalendar(n, mouseWheelEvent.isControlDown());
    }

    void refresh() {
        this.removeAll();
        CalendarPanel calendarPanel = new CalendarPanel(this.calendar, this.fontSize);
        calendarPanel.setOpaque(false);
        for (Component component : MainPanel.getAllComponents(calendarPanel)) {
            component.setFont(component.getFont().deriveFont(this.fontSize));
        }
        this.add((Component)calendarPanel, "Center");
        this.add((Component)this.createControlPanel(), "South");
        this.validate();
        this.requestFocus();
    }

    private static List<Component> getAllComponents(Container container) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : container.getComponents()) {
            arrayList.add(component);
            if (!(component instanceof Container)) continue;
            arrayList.addAll(MainPanel.getAllComponents((Container)component));
        }
        return arrayList;
    }

    void rotateCalendar(int n, boolean bl) {
        if (bl) {
            n *= 12;
        }
        this.calendar.add(2, n);
        this.refresh();
    }

    void jumpToToday() {
        Calendar calendar = Calendar.getInstance();
        this.calendar.set(1, calendar.get(1));
        this.calendar.set(2, calendar.get(2));
        this.refresh();
    }

    private JPanel createControlPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        jPanel.add(MainPanel.createJButton("RR.gif", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.rotateCalendar(-12, false);
            }
        }));
        jPanel.add(MainPanel.createJButton("R.gif", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.rotateCalendar(-1, false);
            }
        }));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel2.add(MainPanel.createJButton("F.gif", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.rotateCalendar(1, false);
            }
        }));
        jPanel2.add(MainPanel.createJButton("FF.gif", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.rotateCalendar(12, false);
            }
        }));
        JLabel jLabel = this.createMonthLabel();
        jLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MainPanel.this.confirmSpecificMonth();
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel, "West");
        jPanel3.add((Component)jLabel, "Center");
        jPanel3.add((Component)jPanel2, "East");
        jPanel3.setOpaque(false);
        return jPanel3;
    }

    JLabel createMonthLabel() {
        String string = Resource.getString("pane.monthformat");
        String string2 = String.format(string, this.calendar);
        JLabel jLabel = new JLabel(string2);
        jLabel.setFont(jLabel.getFont().deriveFont(this.fontSize));
        jLabel.setHorizontalAlignment(0);
        jLabel.setOpaque(false);
        return jLabel;
    }

    void confirmSpecificMonth() {
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.calendar.get(1), 1, 9999, 1);
        SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(this.calendar.get(2) + 1, 1, 12, 1);
        JPanel jPanel = new JPanel(new FlowLayout());
        JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        jSpinner.setEditor(new JSpinner.NumberEditor(jSpinner, "0"));
        jPanel.add(jSpinner);
        jPanel.add(new JSpinner(spinnerNumberModel2));
        if (JOptionPane.showConfirmDialog(this, jPanel, "", 2, 1) == 0) {
            this.calendar.set(1, spinnerNumberModel.getNumber().intValue());
            this.calendar.set(2, spinnerNumberModel2.getNumber().intValue() - 1);
            this.refresh();
        }
    }

    private static JButton createJButton(String string, Action action) {
        Image image = Resource.getImage(string);
        Image image2 = image.getScaledInstance(20, 8, 0);
        JButton jButton = new JButton(new ImageIcon(image2));
        jButton.setFont(jButton.getFont().deriveFont(9.0f));
        jButton.addActionListener(action);
        return jButton;
    }

    void onWindowResized(ComponentEvent componentEvent) {
        float f = Math.min((float)this.getWidth() / 640.0f, (float)this.getHeight() / 480.0f);
        this.fontSize = 24.0f * f;
        this.refresh();
    }
}

