/*
 * Decompiled with CFR 0.152.
 */
package net.argius.calendar;

import java.util.Calendar;
import net.argius.calendar.Day;
import net.argius.calendar.DayOfWeek;
import net.argius.calendar.Month;
import net.argius.calendar.Resource;

public abstract class Holiday {
    protected static final String NOT_HOLIDAY = "";

    static Holiday getInstance() {
        String string = Resource.getString("class.holiday");
        if (string != null && string.length() > 0) {
            try {
                return (Holiday)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new IllegalStateException("class name is not available: " + string);
            }
        }
        return new Holiday(){

            public String getHolidayName(int n, int n2, int n3) {
                return Holiday.NOT_HOLIDAY;
            }
        };
    }

    public Day getDay(Month month, Calendar calendar) {
        int n = calendar.get(5);
        String string = this.getHolidayName(month.getYear(), month.getMonth(), n);
        return new Day(month, n, DayOfWeek.get(calendar.get(7)), string.length() > 0, string);
    }

    protected static boolean validate(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2 - 1, n3, 0, 0, 0);
        return n == calendar.get(1) && n2 == calendar.get(2) + 1 && n3 == calendar.get(5);
    }

    protected final boolean isHoliday(int n, int n2, int n3) {
        return !this.getHolidayName(n, n2, n3).equals(NOT_HOLIDAY);
    }

    public abstract String getHolidayName(int var1, int var2, int var3);
}

