/*
 * Decompiled with CFR 0.152.
 */
package net.argius.calendar;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import net.argius.calendar.Day;
import net.argius.calendar.DayOfWeek;
import net.argius.calendar.LocalProperty;
import net.argius.calendar.Month;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CalendarPanel
extends JPanel {
    private static final int GRID_ROWS = 7;
    private static final int GRID_COLS = 7;
    private static final int COUNT = 49;

    public CalendarPanel(Calendar calendar, float f) {
        assert (calendar.get(5) == 1);
        this.setLayout(new GridLayout(7, 7));
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(49);
        Month month = new Month(calendar.get(1), calendar.get(2) + 1);
        int n = 0;
        assert (n >= 0 && n <= 6);
        this.fillWeekday(arrayList);
        if (n != 0) {
            Collections.rotate(arrayList, n);
        }
        int n2 = month.getDay(1).getDayOfWeek().ordinal();
        if (n != 0) {
            n2 = (n2 + n) % 7;
        }
        Collections.addAll(arrayList, CalendarPanel.getEmptyComponents(n2));
        this.fillDays(arrayList, month);
        Collections.addAll(arrayList, CalendarPanel.getEmptyComponents(49 - arrayList.size()));
        assert (arrayList.size() == 49);
        for (JComponent jComponent : arrayList) {
            this.add(jComponent);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        System.out.println("CalendarPanel.processMouseEvent");
    }

    private void fillWeekday(List<JComponent> list) {
        for (DayOfWeek dayOfWeek : DayOfWeek.values()) {
            JLabel jLabel = new JLabel(dayOfWeek.getLocalizedString());
            jLabel.setHorizontalAlignment(0);
            jLabel.setOpaque(false);
            list.add(jLabel);
        }
    }

    private void fillDays(List<JComponent> list, Month month) {
        int n = 0;
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) == month.getMonth() - 1 && calendar.get(1) == month.getYear()) {
            n = calendar.get(5);
        }
        for (Day day : month.getDays()) {
            JLabel jLabel = new JLabel(String.valueOf(day.getNumber()));
            jLabel.setAlignmentX(0.5f);
            jLabel.setAlignmentY(0.0f);
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(true);
            jPanel.setToolTipText(String.valueOf(day));
            jPanel.add(jLabel);
            LineBorder lineBorder = day.getNumber() == n ? new LineBorder(Color.BLUE, 3) : new LineBorder(Color.LIGHT_GRAY);
            jPanel.setBorder(lineBorder);
            String string = day.isHoliday() ? LocalProperty.getProperty("color.holiday") : (day.getDayOfWeek() == DayOfWeek.Sunday ? LocalProperty.getProperty("color.sunday") : (day.getDayOfWeek() == DayOfWeek.Saturday ? LocalProperty.getProperty("color.saturday") : LocalProperty.getProperty("color.weekday")));
            jPanel.setBackground(Color.decode(string));
            list.add(jPanel);
        }
    }

    private static JComponent[] getEmptyComponents(int n) {
        JComponent[] jComponentArray = new JComponent[n];
        for (int i = 0; i < n; ++i) {
            jComponentArray[i] = new JLabel();
        }
        return jComponentArray;
    }
}

