package net.argius.calendar;

import java.awt.*;
import java.io.*;
import java.util.*;

/**
 * \[XB
 */
public final class Resource {

    /** 󕶎 */
    static final String EMPTY_STRING = "";

    /** ftHgtHgTCY */
    static final float DEFAULT_FONT_SIZE = 24f;

    private static final String BUNDLE_NAME = "net.argius.calendar.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);

    /**
     * Resource̐B
     */
    private Resource() {
        // empty
    }

    /**
     * O̎擾B
     * @param key L[
     * @return 
     */
    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        } catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    /**
     * 摜̎擾B
     * @param name 摜̃\[X
     * @return 摜
     */
    static Image getImage(String name) {
        return Toolkit.getDefaultToolkit().createImage(Resource.class.getResource(name));
    }

    /**
     * o[W̎擾B
     * @return o[W
     */
    public static String getVersion() {
        InputStream is = Resource.class.getResourceAsStream("version");
        try {
            Scanner scanner = new Scanner(is);
            return scanner.nextLine();
        } finally {
            try {
                is.close();
            } catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

}
