package net.argius.calendar;

import java.io.*;
import java.security.*;
import java.util.*;

/**
 * [J̃vpeBB
 * 
 * vpeB́A̗D揇ʂœKpB
 * <ul>
 * <li>1.Cӂ̃vpeB(VXevpeB<code>net.argius.calendar.xxx)</code>
 * <li>2.VXevpeB<code>net.argius.calendar.properties</code>Ŏw肳ꂽt@C
 * <li>3.JgfBNg<code>calendar.properties</code>t@C
 * <li>4.ftHgvpeB(\[X)
 * </ul>
 */
final class LocalProperty {

    static final List<Throwable> errorList = Collections.synchronizedList(new ArrayList<Throwable>());

    private static final Properties props = initialize();

    /**
     * LocalProperty̐B
     */
    private LocalProperty() {
        // empty
    }

    /**
     * vpeB̏B
     * @return vpeB
     */
    private static Properties initialize() {
        Properties defaults = new Properties();
        try {
            // 4.ftHgvpeB
            defaults.load(LocalProperty.class.getResourceAsStream("default.properties"));
        } catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Properties props = new Properties(defaults);
        try {
            // 2.VXevpeBnet.argius.calendar.propertiesŎw肳ꂽt@C
            String path = System.getProperty("net.argius.calendar.properties");
            if (path == null) {
                // 3.JgfBNgcalendar.propertiest@C
                File file = new File("calendar.properties");
                if (file.exists()) {
                    InputStream is = new FileInputStream(file);
                    try {
                        props.load(is);
                    } finally {
                        is.close();
                    }
                }
            } else {
                InputStream is = new FileInputStream(path);
                try {
                    props.load(is);
                } finally {
                    is.close();
                }
            }
            // 1.Cӂ̃vpeB
            for (Object o : defaults.keySet()) {
                try {
                    String key = (String)o;
                    String syskey = "net.argius.calendar." + key;
                    String value = System.getProperty(syskey);
                    if (value != null) {
                        props.setProperty(key, value);
                    }
                } catch (AccessControlException ex) {
                    // ignore
                }
            }
        } catch (IOException ex) {
            errorList.add(ex);
        } catch (AccessControlException ex) {
            errorList.add(ex);
        }
        return props;
    }

    /**
     * vpeB̎擾B
     * @param key vpeBL[
     * @return vpeB(boolean)
     */
    static boolean getBooleanProperty(String key) {
        String value = getProperty(key);
        if (value != null && value.length() == 0) {
            return true;
        }
        return Boolean.valueOf(value);
    }

    /**
     * vpeB̎擾B
     * @param key vpeBL[
     * @return vpeB
     */
    static String getProperty(String key) {
        final Properties p = props;
        final String k = key;
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>() {

                public String run() throws Exception {
                    return p.getProperty(k);
                }

            });
        } catch (PrivilegedActionException ex) {
            errorList.add(ex);
            return null;
        }
    }

    /**
     * vpeB̐ݒB
     * @param key vpeBL[
     * @param value l
     */
    static void setProperty(String key, String value) {
        final Properties p = props;
        final String k = key;
        final String v = value;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<String>() {

                public String run() throws Exception {
                    p.setProperty(k, v);
                    return null;
                }

            });
        } catch (PrivilegedActionException ex) {
            errorList.add(ex);
        }
    }
}
