package net.argius.calendar;

import java.util.*;

/**
 * o[W1DayNXB
 * 
 * ̍\vfƂĂ̓\NXłB
 * NEjEjۗL܂B
 * <br><br>
 * ̃NX̃IuWFNg<code>Month</code>NX̃GgŁAsσIuWFNgłB
 * @see Month
 */
public final class Day1 {

    private Calendar calendar;
    private boolean holiday;
    private String holidayName;

    /**
     * jłȂIuWFNg𐶐܂B
     * @param calendar t
     */
    protected Day1(Calendar calendar) {

        this(calendar, false, "");

    }

    /**
     * IuWFNg𐶐܂B
     * @param calendar t
     * @param holiday jȂ<code>true</code>AłȂ<code>false</code>
     * @param holidayName j̖
     */
    protected Day1(Calendar calendar, boolean holiday, String holidayName) {

        initialize(calendar);
        this.holiday = holiday;
        this.holidayName = holidayName;

    }

    /**
     * s܂B
     * @param calendar t
     */
    private void initialize(Calendar calendar) {

        // O̎QƂۗLȂ悤
        // J_[̃Rs[쐬
        int year = calendar.get(Calendar.YEAR);
        int month = calendar.get(Calendar.MONTH);
        int date = calendar.get(Calendar.DATE);
        this.calendar = new GregorianCalendar(year, month, date);

    }

    /**
     * Ԃ܂B
     * @return 
     */
    public int getNumber() {

        return calendar.get(Calendar.DATE);

    }

    /**
     * jԂ܂B
     * @return <code>Calendar</code>Ŏj萔
     */
    public int getDayOfWeek() {

        return calendar.get(Calendar.DAY_OF_WEEK);

    }

    /**
     * ̓tǂԂB
     * @return ̓tȂ <code>true</code>AłȂ <code>false</code>
     */
    public boolean isToday() {
        Calendar today = Calendar.getInstance();
        int[] types = {Calendar.YEAR, Calendar.MONTH, Calendar.DAY_OF_MONTH};
        for (int i = 0; i < types.length; i++) {
            int type = types[i];
            if (calendar.get(type) != today.get(type)) {
                return false;
            }
        }
        return true;
    }

    /**
     * j̕\Ԃ܂B
     * @return j\
     */
    public String getDayOfWeekToString() {

        switch (getDayOfWeek()) {
            case Calendar.SUNDAY:
                return "";
            case Calendar.MONDAY:
                return "";
            case Calendar.TUESDAY:
                return "";
            case Calendar.WEDNESDAY:
                return "";
            case Calendar.THURSDAY:
                return "";
            case Calendar.FRIDAY:
                return "";
            case Calendar.SATURDAY:
                return "y";
        }

        return "H";

    }

    /**
     * jǂ𒲂ׂ܂B
     * @return holiday jȂ<code>true</code>AłȂ<code>false</code>
     */
    public boolean isHoliday() {

        return holiday;

    }

    /**
     * ĵ̖Ԃ܂B
     * @return j̖
     */
    public String getHolidayName() {

        return holidayName;

    }

    /**
     * ̃IuWFNg̕\Ԃ܂B
     * @return \
     */
    @Override
    public String toString() {

        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        sb.append(calendar.get(Calendar.YEAR));
        sb.append("N ");
        sb.append(calendar.get(Calendar.MONTH) + 1);
        sb.append(" ");
        sb.append(calendar.get(Calendar.DATE));
        sb.append(" ");
        sb.append(getDayOfWeekToString());
        sb.append("j");
        if (holiday) {
            sb.append("    jE");
            sb.append(holidayName);
        }
        return sb.toString();

    }

}
