/*
 * Decompiled with CFR 0.152.
 */
package net.argius.calendar;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import net.argius.calendar.Day;
import net.argius.calendar.Holiday;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Month {
    private static final Holiday HOLIDAY = Holiday.getInstance();
    private final int year;
    private final int month;
    private List<Day> days;

    public Month(int n, int n2) {
        assert (n2 >= 1 && n2 <= 12);
        this.year = n;
        this.month = n2;
        this.days = Collections.unmodifiableList(this.createDays(n, n2));
    }

    private List<? extends Day> createDays(int n, int n2) {
        ArrayList<Day> arrayList = new ArrayList<Day>();
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2 - 1, 1, 0, 0, 0);
        while (calendar.get(2) == n2 - 1) {
            arrayList.add(HOLIDAY.getDay(this, calendar));
            calendar.add(5, 1);
        }
        return arrayList;
    }

    public Day getDay(int n) {
        if (n < 1 || n > this.days.size()) {
            throw new IllegalArgumentException("number=" + n + ", size=" + this.days.size());
        }
        return this.days.get(n - 1);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public List<Day> getDays() {
        return this.days;
    }

    public String toString() {
        return String.format("%04d-%02d", this.year, this.month);
    }
}

