/*
 * Decompiled with CFR 0.152.
 */
package net.argius.calendar;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.argius.calendar.Resource;

final class Menu
extends JMenuBar {
    final Container owner;
    JCheckBoxMenuItem cAlwaysOnTop;
    private List<MenuListener> listeners;

    Menu(Container container) {
        this.owner = container;
        this.listeners = new ArrayList<MenuListener>();
        this.add(Menu.createJMenu("file", 'F', this.createJMenuItem(Item.NEW, 'N', Menu.getKeyStroke(78, true)), this.createJMenuItem(Item.ANNUAL, 'A'), this.createJMenuItem(Item.CLOSE, 'C', Menu.getKeyStroke(87, true)), new JSeparator(), this.createJMenuItem(Item.EXIT, 'Q', Menu.getKeyStroke(81, true))));
        this.add(Menu.createJMenu("navigate", 'N', this.createJMenuItem(Item.TODAY, 'T', Menu.getKeyStroke(36, false)), this.createJMenuItem(Item.PREV_MONTH, 'P', Menu.getKeyStroke(33, false)), this.createJMenuItem(Item.NEXT_MONTH, 'N', Menu.getKeyStroke(34, false)), this.createJMenuItem(Item.PREV_YEAR, 'R', Menu.getKeyStroke(33, true)), this.createJMenuItem(Item.NEXT_YEAR, 'X', Menu.getKeyStroke(34, true))));
        this.cAlwaysOnTop = this.createJCheckBoxMenuItem(Item.ALWAYS_ON_TOP, 'T', Menu.getKeyStroke(84, true));
        this.add(Menu.createJMenu("window", 'W', this.createJMenuItem(Item.ALIGNMENT, 'A'), this.cAlwaysOnTop));
        this.add(Menu.createJMenu("help", 'H', this.createJMenuItem(Item.HELP, 'H'), new JSeparator(), this.createJMenuItem(Item.ABOUT, 'A')));
    }

    void addMenuListener(MenuListener menuListener) {
        this.listeners.add(menuListener);
    }

    void removeMenuListener(MenuListener menuListener) {
        this.listeners.remove(menuListener);
    }

    void fireMenuSelected(Item item) {
        MenuEvent menuEvent = new MenuEvent((Object)item);
        for (MenuListener menuListener : this.listeners) {
            menuListener.menuSelected(menuEvent);
        }
    }

    private static JMenu createJMenu(String string, char c, JComponent ... jComponentArray) {
        JMenu jMenu = new JMenu(Menu.getString(string));
        jMenu.setMnemonic(c);
        for (JComponent jComponent : jComponentArray) {
            jMenu.add(jComponent);
        }
        return jMenu;
    }

    private JMenuItem createJMenuItem(Item item, char c) {
        JMenuItem jMenuItem = new JMenuItem(Menu.getString(item.getString()), c);
        jMenuItem.setName(item.name());
        final Item item2 = item;
        jMenuItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.fireMenuSelected(item2);
            }
        });
        return jMenuItem;
    }

    private JMenuItem createJMenuItem(Item item, char c, KeyStroke keyStroke) {
        JMenuItem jMenuItem = this.createJMenuItem(item, c);
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        return jMenuItem;
    }

    private JCheckBoxMenuItem createJCheckBoxMenuItem(Item item, char c, KeyStroke keyStroke) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Menu.getString(item.getString()));
        jCheckBoxMenuItem.setMnemonic(c);
        if (keyStroke != null) {
            jCheckBoxMenuItem.setAccelerator(keyStroke);
        }
        final Item item2 = item;
        jCheckBoxMenuItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Menu.this.fireMenuSelected(item2);
            }
        });
        return jCheckBoxMenuItem;
    }

    private static KeyStroke getKeyStroke(int n, boolean bl) {
        return KeyStroke.getKeyStroke(n, bl ? 2 : 0);
    }

    private static String getString(String string) {
        return Resource.getString("menu." + string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Item {
        NEW("file.new"),
        ANNUAL("file.annual"),
        CLOSE("file.close"),
        EXIT("file.exit"),
        TODAY("navigate.today"),
        NEXT_MONTH("navigate.nextmonth"),
        PREV_MONTH("navigate.prevmonth"),
        NEXT_YEAR("navigate.nextyear"),
        PREV_YEAR("navigate.prevyear"),
        ALIGNMENT("window.alignment"),
        ALWAYS_ON_TOP("window.alwaysontop"),
        COLOR("window.color"),
        HELP("help.help"),
        ABOUT("help.about");

        private String string;

        private Item(String string2) {
            this.string = string2;
        }

        String getString() {
            return this.string;
        }
    }
}

