package net.argius.calendar;

import static java.util.Calendar.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.border.*;

/**
 * J_[plB
 */
public final class CalendarPanel extends JPanel {

    private static final int GRID_ROWS = 7;
    private static final int GRID_COLS = 7;
    private static final int COUNT = GRID_ROWS * GRID_COLS;

    /**
     * CalendarComponent̐B
     * @param calendar J_[(1ł邱) 
     * @param fontSize tHgTCY
     */
    public CalendarPanel(Calendar calendar, float fontSize) {
        assert calendar.get(DAY_OF_MONTH) == 1;
        setLayout(new GridLayout(GRID_ROWS, GRID_COLS));
        setOpaque(true);
        setBackground(Color.WHITE);
        List<JComponent> daycomps = new ArrayList<JComponent>(COUNT);
        Month month = new Month(calendar.get(YEAR), calendar.get(MONTH) + 1);
        int adjustment = 0;
        assert adjustment >= 0 && adjustment <= 6;
        // j
        fillWeekday(daycomps);
        if (adjustment != 0) {
            Collections.rotate(daycomps, adjustment);
        }
        // 擪̋
        int firstDayOfWeek = month.getDay(1).getDayOfWeek().ordinal();
        if (adjustment != 0) {
            firstDayOfWeek = (firstDayOfWeek + adjustment) % 7;
        }
        Collections.addAll(daycomps, getEmptyComponents(firstDayOfWeek));
        // t
        fillDays(daycomps, month);
        // ̋
        Collections.addAll(daycomps, getEmptyComponents(COUNT - daycomps.size()));
        // zu
        assert daycomps.size() == COUNT;
        for (JComponent c : daycomps) {
            add(c);
        }
    }

    /* @see javax.swing.JComponent#processMouseEvent(java.awt.event.MouseEvent) */
    @Override
    protected void processMouseEvent(MouseEvent e) {
        System.out.println("CalendarPanel.processMouseEvent");
    }

    /**
     * j𖄂߂B
     * @param daycomps R|[lgXg
     */
    private void fillWeekday(List<JComponent> daycomps) {
        for (DayOfWeek w : DayOfWeek.values()) {
            JLabel label = new JLabel(w.getLocalizedString());
            label.setHorizontalAlignment(SwingConstants.CENTER);
            label.setOpaque(false);
            daycomps.add(label);
        }
    }

    /**
     * t𖄂߂B
     * @param daycomps R|[lgXg
     * @param month 
     */
    private void fillDays(List<JComponent> daycomps, Month month) {
        // 
        int today = 0;
        Calendar now = Calendar.getInstance();
        if (now.get(MONTH) == month.getMonth() - 1 && now.get(YEAR) == month.getYear()) {
            today = now.get(DAY_OF_MONTH);
        }
        // 1`
        for (Day day : month.getDays()) {
            JLabel label = new JLabel(String.valueOf(day.getNumber()));
            label.setAlignmentX(CENTER_ALIGNMENT);
            label.setAlignmentY(TOP_ALIGNMENT);
            JPanel p = new JPanel();
            p.setOpaque(true);
            p.setToolTipText(String.valueOf(day));
            p.add(label);
            LineBorder border;
            if (day.getNumber() == today) {
                border = new LineBorder(Color.BLUE, 3);
            } else {
                border = new LineBorder(Color.LIGHT_GRAY);
            }
            p.setBorder(border);
            String colorString;
            if (day.isHoliday()) {
                colorString = LocalProperty.getProperty("color.holiday");
            } else if (day.getDayOfWeek() == DayOfWeek.Sunday) {
                colorString = LocalProperty.getProperty("color.sunday");
            } else if (day.getDayOfWeek() == DayOfWeek.Saturday) {
                colorString = LocalProperty.getProperty("color.saturday");
            } else {
                colorString = LocalProperty.getProperty("color.weekday");
            }
            p.setBackground(Color.decode(colorString));
            daycomps.add(p);
        }
    }

    /**
     * ̃R|[lg̔z擾B
     * @param count 
     * @return ̃R|[lg̔z
     */
    private static JComponent[] getEmptyComponents(int count) {
        JComponent[] components = new JComponent[count];
        for (int i = 0; i < count; i++) {
            components[i] = new JLabel();
        }
        return components;
    }

}
