package net.argius.calendar;

import static java.awt.event.KeyEvent.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.util.List;

import javax.swing.*;
import javax.swing.event.*;

/**
 * j[B
 */
final class Menu extends JMenuBar {

    /**
     * j[ځB
     */
    enum Item {
        /**
         * <code>NEW</code>
         */
        NEW("file.new"),

        /**
         * <code>ANNUAL</code>
         */
        ANNUAL("file.annual"),

        /**
         * <code>CLOSE</code>
         */
        CLOSE("file.close"),

        /**
         * <code>EXIT</code>
         */
        EXIT("file.exit"),

        /**
         * <code>TODAY</code>
         */
        TODAY("navigate.today"),

        /**
         * <code>NEXT_MONTH</code>
         */
        NEXT_MONTH("navigate.nextmonth"),

        /**
         * <code>PREV_MONTH</code>
         */
        PREV_MONTH("navigate.prevmonth"),

        /**
         * <code>NEXT_YEAR</code>
         */
        NEXT_YEAR("navigate.nextyear"),

        /**
         * <code>PREV_YEAR</code>
         */
        PREV_YEAR("navigate.prevyear"),

        /**
         * <code>ALIGNMENT</code>
         */
        ALIGNMENT("window.alignment"),

        /**
         * <code>ALWAYS_ON_TOP</code>
         */
        ALWAYS_ON_TOP("window.alwaysontop"),

        /**
         * <code>COLOR</code>
         */
        COLOR("window.color"),

        /**
         * <code>HELP</code>
         */
        HELP("help.help"),

        /**
         * <code>ABOUT</code>
         */
        ABOUT("help.about");

        private String string;

        /**
         * Item̐B
         * @param string ږ
         */
        private Item(String string) {
            this.string = string;
        }

        /**
         * ږ̎擾B
         * @return ږ
         */
        String getString() {
            return string;
        }

    }

    final Container owner;

    JCheckBoxMenuItem cAlwaysOnTop;

    private List<MenuListener> listeners;

    /**
     * Menu̐B
     * @param owner I[i
     */
    Menu(Container owner) {
        this.owner = owner;
        this.listeners = new ArrayList<MenuListener>();
        add(createJMenu("file",
                        'F',
                        createJMenuItem(Item.NEW, 'N', getKeyStroke(VK_N, true)),
                        createJMenuItem(Item.ANNUAL, 'A'),
                        createJMenuItem(Item.CLOSE, 'C', getKeyStroke(VK_W, true)),
                        new JSeparator(),
                        createJMenuItem(Item.EXIT, 'Q', getKeyStroke(VK_Q, true))));
        add(createJMenu("navigate",
                        'N',
                        createJMenuItem(Item.TODAY, 'T', getKeyStroke(VK_HOME, false)),
                        createJMenuItem(Item.PREV_MONTH, 'P', getKeyStroke(VK_PAGE_UP, false)),
                        createJMenuItem(Item.NEXT_MONTH, 'N', getKeyStroke(VK_PAGE_DOWN, false)),
                        createJMenuItem(Item.PREV_YEAR, 'R', getKeyStroke(VK_PAGE_UP, true)),
                        createJMenuItem(Item.NEXT_YEAR, 'X', getKeyStroke(VK_PAGE_DOWN, true))));
        cAlwaysOnTop = createJCheckBoxMenuItem(Item.ALWAYS_ON_TOP, 'T', getKeyStroke(VK_T, true));
        add(createJMenu("window", 'W', createJMenuItem(Item.ALIGNMENT, 'A'), cAlwaysOnTop));
        add(createJMenu("help",
                        'H',
                        createJMenuItem(Item.HELP, 'H'),
                        new JSeparator(),
                        createJMenuItem(Item.ABOUT, 'A')));
    }

    /**
     * MenuListener̓o^B
     * @param listener MenuListener
     */
    void addMenuListener(MenuListener listener) {
        listeners.add(listener);
    }

    /**
     * MenuListener̉B
     * @param listener MenuListener
     */
    void removeMenuListener(MenuListener listener) {
        listeners.remove(listener);
    }

    /**
     * j[IꂽƂʒmB
     * @param item j[
     */
    void fireMenuSelected(Item item) {
        MenuEvent event = new MenuEvent(item);
        for (MenuListener listener : listeners) {
            listener.menuSelected(event);
        }
    }

    /**
     * JMenu̐B
     * @param key \̃L[
     * @param mnemonic 蓖ĕ
     * @param components R|[lg̔z
     * @return JMenu    
     */
    private static JMenu createJMenu(String key, char mnemonic, JComponent... components) {
        JMenu menu = new JMenu(getString(key));
        menu.setMnemonic(mnemonic);
        for (JComponent component : components) {
            menu.add(component);
        }
        return menu;
    }

    /**
     * JMenuItem̐B
     * @param key j[L[
     * @param mnemonic 蓖ĕ
     * @return JMenuItem
     */
    private JMenuItem createJMenuItem(Item key, char mnemonic) {
        JMenuItem o = new JMenuItem(getString(key.getString()), mnemonic);
        o.setName(key.name());
        final Item actionKey = key;
        o.addActionListener(new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                fireMenuSelected(actionKey);
            }

        });
        return o;
    }

    /**
     * JMenuItem̐B
     * @param key j[L[
     * @param mnemonic 蓖ĕ
     * @param shortcut V[gJbgL[
     * @return JMenuItem
     */
    private JMenuItem createJMenuItem(Item key, char mnemonic, KeyStroke shortcut) {
        JMenuItem o = createJMenuItem(key, mnemonic);
        if (shortcut != null) {
            o.setAccelerator(shortcut);
        }
        return o;
    }

    /**
     * JCheckBoxMenuItem̐B
     * @param key j[L[
     * @param mnemonic 蓖ĕ
     * @param shortcut V[gJbgL[
     * @return JCheckBoxMenuItem
     */
    private JCheckBoxMenuItem createJCheckBoxMenuItem(Item key, char mnemonic, KeyStroke shortcut) {
        JCheckBoxMenuItem o = new JCheckBoxMenuItem(getString(key.getString()));
        o.setMnemonic(mnemonic);
        if (shortcut != null) {
            o.setAccelerator(shortcut);
        }
        final Item actionKey = key;
        o.addActionListener(new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                fireMenuSelected(actionKey);
            }

        });
        return o;
    }

    /**
     * KeyStroke̎擾B
     * @param key L[
     * @param withControlKey Rg[L[gpꍇ <code>true</code>
     * @return KeyStroke
     */
    private static KeyStroke getKeyStroke(int key, boolean withControlKey) {
        return KeyStroke.getKeyStroke(key, (withControlKey ? InputEvent.CTRL_MASK : 0));
    }

    /**
     * ̎擾B
     * @param key L[
     * @return 
     */
    private static String getString(String key) {
        return Resource.getString("menu." + key);
    }

}
