package net.argius.calendar;

import static java.lang.Math.floor;
import static java.util.Calendar.*;

import java.util.*;

/**
 * {̏jB
 * 
 * <p>
 * WbN쐬ɂāAȉ̃y[WQlɂB
 * <dl>
 * <dt>jɂ - Addin Box</dt>
 * <dd>http://www.h3.dion.ne.jp/~sakatsu/holiday_topic.htm</dd>
 * <dt>̏j̃[c - ubWs͂łȂB</dt>
 * <dd>http://www.k4.dion.ne.jp/~bridging/kyujitsu.html</dd>
 * <dt>xj萃Xi@̏j@j - ݂̃y[W</dt>
 * <dd>http://koyomi.vis.ne.jp/sub/syukujitsuhou_meiji.htm</dd>
 * </dl>
 */
public final class JapaneseHoliday extends Holiday {

    private static final String HAPPY_MONDAY = "inbs[}f[j";

    /**
     * jłΏj擾B
     * @param year N
     * @param month (1`12)
     * @param day 
     * @return j̏ꍇ͏jAłȂ΋󕶎
     */
    @Override
    public String getHolidayName(int year, int month, int day) {
        assert validate(year, month, day);
        if (compare(1948, 7, 20, year, month, day) >= 0) {
            return getHolidayName19480720(year, month, day);
        } else if (year >= 1873) {
            return getHolidayName18730101(year, month, day);
        } else {
            /*
             * j@ȑȌtEH H
             */
            MonthDay date = new MonthDay(month, day);
            if (date.is(getVernalEquinoxDay(year))) {
                return "t (jH)";
            }
            if (date.is(getAutumnalEquinoxDay(year))) {
                return "H (jH)";
            }
        }
        return NOT_HOLIDAY;
    }

    /**
     * ȕjɊւ@vɊÂjԂB
     * a23(1948)N720{sB
     * @param year N
     * @param month 
     * @param day 
     * @return j
     */
    private static String getHolidayName19480720(int year, int month, int day) {
        MonthDay date = new MonthDay(month, day);
        // U
        if (date.is(1, 1)) {
            return "U";
        }
        // l̓
        if (month == 1) {
            final String name = "l̓";
            if (year >= 2000) {
                if (date.is(getHappyMonday(year, 1, 2))) {
                    return name + HAPPY_MONDAY;
                }
            } else {
                if (date.is(1, 15)) {
                    return name;
                }
            }
        }
        // LO
        if (year >= 1967) {
            if (date.is(2, 11)) {
                return "LO̓";
            }
        }
        // t̓
        if (date.is(getVernalEquinoxDay(year))) {
            return "t̓";
        }
        // a̓ ݂ǂ̓(1989-) Vca(1949-)
        if (year >= 2007) {
            if (date.is(4, 29)) {
                return "a̓";
            }
        } else if (year >= 1989) {
            if (date.is(4, 29)) {
                return "݂ǂ̓";
            }
        } else {
            if (date.is(4, 29)) {
                return "Vca";
            }
        }
        // @LO
        if (date.is(5, 3)) {
            return "@LO";
        }
        // ݂ǂ̓
        if (year >= 2007) {
            if (date.is(5, 4)) {
                return "݂ǂ̓";
            }
        } else {
            // ̋x͍Ōɋ߂(2006N܂)
        }
        // q̓
        if (date.is(5, 5)) {
            return "q̓";
        }
        // C̓
        if (year >= 1996) {
            final String name = "C̓";
            if (year >= 2003) {
                if (date.is(getHappyMonday(year, 7, 3))) {
                    return name + HAPPY_MONDAY;
                }
            } else {
                if (date.is(7, 19)) {
                    return name;
                }
            }
        }
        // hV̓
        MonthDay respectForTheAgedDay;
        if (year >= 1966) {
            final String name = "hV̓";
            if (year >= 2003) {
                respectForTheAgedDay = getHappyMonday(year, 9, 3);
                if (date.is(respectForTheAgedDay)) {
                    return name + HAPPY_MONDAY;
                }
            } else {
                respectForTheAgedDay = new MonthDay(9, 15);
                if (date.is(respectForTheAgedDay)) {
                    return name;
                }
            }
        } else {
            respectForTheAgedDay = new MonthDay(9, 15);
        }
        // H̓
        MonthDay autumnalEquinoxDay = getAutumnalEquinoxDay(year);
        if (date.is(autumnalEquinoxDay)) {
            return "H̓";
        }
        // ̈̓
        if (year >= 1966) {
            final String name = "̈̓";
            if (year >= 2003) {
                if (date.is(getHappyMonday(year, 10, 2))) {
                    return name + HAPPY_MONDAY;
                }
            } else {
                if (date.is(10, 10)) {
                    return name;
                }
            }
        }
        // ̓
        if (date.is(11, 3)) {
            return "̓";
        }
        // ΘJӂ̓
        if (date.is(11, 23)) {
            return "ΘJӂ̓";
        }
        // Vca
        if (year >= 1989 && date.is(12, 23)) {
            return "Vca";
        }
        /*
         * ̋xɂ
         * 
         * ̋x́A`(j@RR)WbN
         * ʂȂ̂ŁAł̎ZoʂpB
         * 
         * ̓Iɂ́A2004N10݁A
         * ̋xɂȂ肤
         * Eu@LOv(5/3)Ɓuǂ̓v(5/5)
         * EuhV̓v(93j)ƁuH̓v(9/22,23)
         *    hV̓̃nbs[}f[́A2003/1/1Ɏ{sꂽB
         * Ȃ̂ŁÂQӏ`FbNB
         * ܂Aűx@v{sꂽ̂1985/12/27A
         * L̗RɂAu1986Nȍ~vƂB
         * 
         * 5/4͏ɋx݂ƂȂ邪A͈قȂB(2006N܂)
         * Ej̏ꍇ́Aj
         * Ej̏ꍇ́A@LO̐U֋x
         * ELȊȌꍇ́A̋xŏj
         * 
         * 2007Nȍ~͌Œ̏ji݂ǂ̓jƂȂB
         */
        if (year >= 1986) {
            final String name = "̋x";
            if (year < 2007) {
                // TS̃`FbN
                if (date.is(5, 4)) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(year, 5 - 1, 4, 0, 0, 0);
                    int dayOfWeek = calendar.get(DAY_OF_WEEK);
                    if (dayOfWeek != SUNDAY && dayOfWeek != MONDAY) {
                        return name;
                    }
                }
            }
            if (year >= 2003) {
                // hV̓ƏH̓`FbN
                if (respectForTheAgedDay.day == autumnalEquinoxDay.day - 2
                    && date.is(respectForTheAgedDay.month, respectForTheAgedDay.day + 1)) {
                    return name;
                }
            }
        }
        // U֋x
        if (year >= 1973) {
            // 1973/04/12{s
            final String name = "U֋x";
            if (year >= 2007 && date.is(5, 6)) {
                /*
                 *  2007/01/01{s
                 * 5/3,4,5̂ꂩj̏ꍇ5/6U֋x
                 *  5/3|y|̂ꂩ
                 */
                Calendar c = Calendar.getInstance();
                c.set(year, 5 - 1, 3, 0, 0, 0);
                int dayOfWeek = c.get(DAY_OF_WEEK);
                switch (dayOfWeek) {
                    case FRIDAY:
                    case SATURDAY:
                    case SUNDAY:
                        return name;
                    default:
                        break;
                }
            }
            if (compare(1973, 4, 12, year, month, day) >= 0) {
                Calendar c = Calendar.getInstance();
                c.set(year, month - 1, day, 0, 0, 0);
                if (c.get(DAY_OF_WEEK) == MONDAY) {
                    c.add(DAY_OF_MONTH, -1);
                    String previous = getHolidayName19480720(c.get(YEAR),
                                                             c.get(MONTH) + 1,
                                                             c.get(DAY_OF_MONTH));
                    if (!previous.equals(NOT_HOLIDAY)) {
                        return String.format("%si%sj", name, previous);
                    }
                }
            }
        }
        return NOT_HOLIDAY;
    }

    /**
     * nbs[}f[擾B
     * @param year N
     * @param month 
     * @param ordinal Hj
     * @return nbs[}f[
     */
    private static MonthDay getHappyMonday(int year, int month, int ordinal) {
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, 1, 0, 0, 0);
        for (int i = 0; i < 31; i++) {
            if (c.get(DAY_OF_WEEK) == MONDAY) {
                int dayOfWeekInMonth = c.get(DAY_OF_WEEK_IN_MONTH);
                if (dayOfWeekInMonth >= ordinal) {
                    break;
                }
            }
            c.add(DATE, +1);
        }
        return new MonthDay(c);
    }

    /**
     * j@(1878/06/05`sj@{sO)ɊÂjԂB
     * @param year N
     * @param month 
     * @param day 
     * @return j
     */
    private static String getHolidayName18730101(int year, int month, int day) {
        /*
         * FNՓjmxɓ胀(z)
         * 吳EaFxj萃X()
         * 
         * 1F11N(1878/06/05z)
         * 2F12N(1879/07/05z)
         * 3F吳N(1912/09/04z{s)
         * 3-1:吳2N(1913/07/16z{s)
         * 4Fa2N (1927/03/04z{s)
         */
        MonthDay date = new MonthDay(month, day);
        if (date.is(1, 3)) {
            return "n";
        }
        if (date.is(1, 5)) {
            return "VN";
        }
        if (year <= 1912 && date.is(1, 30)) {
            // 3 {sO܂
            return "FVc";
        }
        if (date.is(2, 11)) {
            return "I";
        }
        if (date.is(4, 3)) {
            return "_Vc";
        }
        if (year >= 1912 && year < 1927 && date.is(7, 30)) {
            // 3  4 {sO܂
            return "Vc";
        }
        // _
        if (year < 1879 && date.is(9, 17) || year >= 1879 && date.is(10, 17)) {
            // 2 tύX(9/1710/17)
            return "_";
        }
        // V
        if (year < 1912
            && date.is(11, 3)
            || year < 1927
            && date.is(8, 31)
            || year >= 1927
            && date.is(4, 29)) {
            // 3 tύX(11/38/31)
            // 4 tύX(8/314/29)
            return "V";
        }
        if (year >= 1913 && year < 1927 && date.is(10, 31)) {
            // 3-1  4 {sO܂
            return "Vߏj";
        }
        // V
        if (date.is(11, 23)) {
            return "V";
        }
        // 吳Vc
        if (year >= 1927 && date.is(12, 25)) {
            // a2N(1927/03/04z{s) 
            return "吳Vc";
        }
        // tEH
        if (year >= 1878) {
            // 1 
            if (date.is(getVernalEquinoxDay(year))) {
                return "tGcˍ";
            }
            if (date.is(getAutumnalEquinoxDay(year))) {
                return "HGcˍ";
            }
        }
        return NOT_HOLIDAY;
    }

    /**
     * w肳ꂽN̏t̓擾B
     * @param year w肳ꂽN()
     * @return w肳ꂽN̏t̓
     */
    private static MonthDay getVernalEquinoxDay(int year) {
        // x = [ rete1 + rate2 * (year - 1900) ] - [ (year - 1900) / 4 ]
        final double rate1 = 21.4471f;
        final double rate2 = 0.242377f;
        double result1 = rate1 + rate2 * (year - 1900);
        double result2 = (year - 1900) / 4d;
        int adjustment = ((int)floor(result1)) - ((int)floor(result2));
        // 3/1̑Oɂ
        Calendar c = Calendar.getInstance();
        c.set(year, 3 - 1, 1, 0, 0, 0);
        c.add(DAY_OF_MONTH, adjustment - 1);
        return new MonthDay(c.get(MONTH) + 1, c.get(DAY_OF_MONTH));
    }

    /**
     * w肳ꂽN̏H̓擾B
     * @param year w肳ꂽN()
     * @return w肳ꂽN̏H̓
     */
    private static MonthDay getAutumnalEquinoxDay(int year) {
        // x = [ rete1 + rate2 * (year - 1900) ] - [ (year - 1900) / 4 ]
        final double rate1 = 23.8896f;
        final double rate2 = 0.242032f;
        double result1 = rate1 + rate2 * (year - 1900);
        double result2 = (year - 1900) / 4d;
        int adjustment = ((int)floor(result1)) - ((int)floor(result2));
        // 9/1̑Oɂ
        Calendar c = Calendar.getInstance();
        c.set(year, 9 - 1, 1, 0, 0, 0);
        c.add(DAY_OF_MONTH, adjustment - 1);
        return new MonthDay(c.get(MONTH) + 1, c.get(DAY_OF_MONTH));
    }

    /**
     * N̔rB
     * @param year1 N1
     * @param month1 1
     * @param day1 1
     * @param year2 N2
     * @param month2 2
     * @param day2 2
     * @return r(<code>1/0/-1</code>)
     */
    private static int compare(int year1, int month1, int day1, int year2, int month2, int day2) {
        if (year1 != year2) {
            return year1 > year2 ? -1 : 1;
        }
        if (month1 != month2) {
            return month1 > month2 ? -1 : 1;
        }
        if (day1 != day2) {
            return day1 > day2 ? -1 : 1;
        }
        return 0;
    }

    /**
     * L[IuWFNgB
     * (month-day)
     */
    private static final class MonthDay extends Pair<Integer, Integer> {

        int month;
        int day;

        /**
         * MonthDay̐B
         * @param calendar Calendar
         */
        public MonthDay(Calendar calendar) {
            this(calendar.get(MONTH) + 1, calendar.get(DAY_OF_MONTH));
        }

        /**
         * MonthDay̐B
         * @param month (1`12)
         * @param day 
         */
        public MonthDay(int month, int day) {
            super(month, day);
            assert month >= 1 && month <= 12;
            this.month = month;
            this.day = day;
        }

        /**
         * tvĂ邩ǂ𒲍B
         * @param month 
         * @param day 
         * @return tvꍇ <code>true</code> AłȂ <code>false</code>
         */
        boolean is(int month, int day) {
            return month == this.month && day == this.day;
        }

        /**
         * tvĂ邩ǂ𒲍B
         * @param d t
         * @return tvꍇ <code>true</code> AłȂ <code>false</code>
         */
        boolean is(MonthDay d) {
            return equals(d);
        }

        /* @see java.lang.Object#toString() */
        @Override
        public String toString() {
            return month + "/" + day;
        }

    }

}
