package net.argius.calendar;

import static java.util.Calendar.*;

import java.util.*;

/**
 * jB
 */
public abstract class Holiday {

    protected static final String NOT_HOLIDAY = "";

    /**
     * CX^X̎擾B
     * @return CX^X
     */
    static Holiday getInstance() {
        String className = Resource.getString("class.holiday");
        if (className != null && className.length() > 0) {
            try {
                return (Holiday)Class.forName(className).newInstance();
            } catch (Exception ex) {
                throw new IllegalStateException("class name is not available: " + className);
            }
        }
        return new Holiday() {

            @Override
            public String getHolidayName(int year, int month, int day) {
                return NOT_HOLIDAY;
            }

        };
    }

    /**
     * 擾B
     * @param month 
     * @param calendar Calendar
     * @return 
     */
    public Day getDay(Month month, Calendar calendar) {
        int dayNumber = calendar.get(DAY_OF_MONTH);
        String holidayName = getHolidayName(month.getYear(), month.getMonth(), dayNumber);
        return new Day(month,
                       dayNumber,
                       DayOfWeek.get(calendar.get(DAY_OF_WEEK)),
                       holidayName.length() > 0,
                       holidayName);
    }

    /**
     * t̑Ó`FbNB
     * @param year N
     * @param month 
     * @param day 
     * @return tÓł <code>true</code> AłȂ <code>false</code>
     */
    protected static boolean validate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, day, 0, 0, 0);
        return year == c.get(YEAR) && month == c.get(MONTH) + 1 && day == c.get(DAY_OF_MONTH);
    }

    /**
     * tjǂ𒲍B
     * @param year N
     * @param month 
     * @param day 
     * @return tjł <code>true</code> AłȂ <code>false</code>
     */
    protected final boolean isHoliday(int year, int month, int day) {
        return !getHolidayName(year, month, day).equals(NOT_HOLIDAY);
    }

    /**
     * ĵ̖擾B
     * @param year N
     * @param month 
     * @param day 
     * @return j̖
     */
    public abstract String getHolidayName(int year, int month, int day);

}
