package net.argius.calendar;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;

import javax.swing.*;

/**
 * wṽANVB
 */
final class HelpAction extends AbstractAction {

    private final Container parent;

    /**
     * HelpAction̐B
     * @param parent eR|[lg
     */
    public HelpAction(Container parent) {
        this.parent = parent;
    }

    /* @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent) */
    public void actionPerformed(ActionEvent e) {
        try {
            Class<? extends HelpAction> c = getClass();
            String name = "help_" + Locale.getDefault().getLanguage();
            URL url = c.getResource(name);
            showEditorPane(parent, (url == null) ? c.getResource("help_en") : url);
        } catch (Throwable th) {
            JOptionPane.showMessageDialog(parent, th);
        }
    }

    /**
     * EditorPane̕\B
     * @param parent eR|[lg
     * @param url wvt@CURL
     * @throws IOException o̓G[ꍇ
     */
    private static void showEditorPane(Container parent, URL url) throws IOException {
        try {
            JEditorPane ep = new JEditorPane(url);
            ep.setEditable(false);
            JScrollPane sp = new JScrollPane(ep);
            JOptionPane pane = new JOptionPane(sp,
                                               JOptionPane.PLAIN_MESSAGE,
                                               JOptionPane.DEFAULT_OPTION);
            JDialog dialog = pane.createDialog(parent, "HELP");
            dialog.setResizable(true);
            Point p = parent.getLocation();
            p.x += 10;
            p.y += 10;
            dialog.setLocation(p);
            Dimension d = parent.getSize();
            d.width *= 0.9;
            d.height *= 0.9;
            dialog.setSize(d);
            dialog.setVisible(true);
        } catch (MalformedURLException ex) {
            IOException ioe = new IOException();
            ioe.initCause(ex);
            throw ioe;
        }
    }

}
