package net.argius.calendar;

/**
 * tB
 */
public final class Day {

    private final Month month;
    private final int number;
    private final DayOfWeek dayOfWeek;
    private final boolean holiday;
    private final String holidayName;

    /**
     * Day̐B
     * @param month 
     * @param number 
     * @param weekday j
     * @param holiday j̏ꍇ <code>true</code>AłȂ <code>false</code>
     * @param holidayName j
     */
    public Day(Month month, int number, DayOfWeek weekday, boolean holiday, String holidayName) {
        this.month = month;
        this.number = number;
        this.dayOfWeek = weekday;
        this.holiday = holiday;
        this.holidayName = holidayName;
    }

    /**
     * month̎擾B
     * @return month
     */
    public Month getMonth() {
        return month;
    }

    /**
     * number̎擾B
     * @return number
     */
    public int getNumber() {
        return number;
    }

    /**
     * dayOfWeek̎擾B
     * @return dayOfWeek
     */
    public DayOfWeek getDayOfWeek() {
        return dayOfWeek;
    }

    /**
     * holiday̎擾B
     * @return holiday
     */
    public boolean isHoliday() {
        return holiday;
    }

    /**
     * holidayName̎擾B
     * @return holidayName
     */
    public String getHolidayName() {
        return holidayName;
    }

    /* @see java.lang.Object#toString() */
    @Override
    public String toString() {
        return String.format("%s-%02d %s %s",
                             month,
                             number,
                             dayOfWeek.getLocalizedString(),
                             holidayName);
    }

}
