/*
 * Decompiled with CFR 0.152.
 */
package net.argius.calendar;

import java.util.Calendar;
import net.argius.calendar.Holiday;
import net.argius.calendar.Pair;

public final class JapaneseHoliday
extends Holiday {
    private static final String HAPPY_MONDAY = "\uff08\u30cf\u30c3\u30d4\u30fc\u30de\u30f3\u30c7\u30fc\uff09";

    public String getHolidayName(int n, int n2, int n3) {
        assert (JapaneseHoliday.validate(n, n2, n3));
        if (JapaneseHoliday.compare(1948, 7, 20, n, n2, n3) >= 0) {
            return JapaneseHoliday.getHolidayName19480720(n, n2, n3);
        }
        if (n >= 1873) {
            return JapaneseHoliday.getHolidayName18730101(n, n2, n3);
        }
        MonthDay monthDay = new MonthDay(n2, n3);
        if (monthDay.is(JapaneseHoliday.getVernalEquinoxDay(n))) {
            return "\u6625\u5206\u65e5 (\u795d\u65e5\uff1f)";
        }
        if (monthDay.is(JapaneseHoliday.getAutumnalEquinoxDay(n))) {
            return "\u79cb\u5206\u65e5 (\u795d\u65e5\uff1f)";
        }
        return "";
    }

    private static String getHolidayName19480720(int n, int n2, int n3) {
        int n4;
        Calendar calendar;
        MonthDay monthDay;
        MonthDay monthDay2;
        MonthDay monthDay3 = new MonthDay(n2, n3);
        if (monthDay3.is(1, 1)) {
            return "\u5143\u65e6";
        }
        if (n2 == 1) {
            if (n >= 2000) {
                if (monthDay3.is(JapaneseHoliday.getHappyMonday(n, 1, 2))) {
                    return "\u6210\u4eba\u306e\u65e5\uff08\u30cf\u30c3\u30d4\u30fc\u30de\u30f3\u30c7\u30fc\uff09";
                }
            } else if (monthDay3.is(1, 15)) {
                return "\u6210\u4eba\u306e\u65e5";
            }
        }
        if (n >= 1967 && monthDay3.is(2, 11)) {
            return "\u5efa\u56fd\u8a18\u5ff5\u306e\u65e5";
        }
        if (monthDay3.is(JapaneseHoliday.getVernalEquinoxDay(n))) {
            return "\u6625\u5206\u306e\u65e5";
        }
        if (n >= 2007) {
            if (monthDay3.is(4, 29)) {
                return "\u662d\u548c\u306e\u65e5";
            }
        } else if (n >= 1989) {
            if (monthDay3.is(4, 29)) {
                return "\u307f\u3069\u308a\u306e\u65e5";
            }
        } else if (monthDay3.is(4, 29)) {
            return "\u5929\u7687\u8a95\u751f\u65e5";
        }
        if (monthDay3.is(5, 3)) {
            return "\u61b2\u6cd5\u8a18\u5ff5\u65e5";
        }
        if (n >= 2007 && monthDay3.is(5, 4)) {
            return "\u307f\u3069\u308a\u306e\u65e5";
        }
        if (monthDay3.is(5, 5)) {
            return "\u5b50\u4f9b\u306e\u65e5";
        }
        if (n >= 1996) {
            if (n >= 2003) {
                if (monthDay3.is(JapaneseHoliday.getHappyMonday(n, 7, 3))) {
                    return "\u6d77\u306e\u65e5\uff08\u30cf\u30c3\u30d4\u30fc\u30de\u30f3\u30c7\u30fc\uff09";
                }
            } else if (monthDay3.is(7, 19)) {
                return "\u6d77\u306e\u65e5";
            }
        }
        if (n >= 1966) {
            if (n >= 2003) {
                monthDay2 = JapaneseHoliday.getHappyMonday(n, 9, 3);
                if (monthDay3.is(monthDay2)) {
                    return "\u656c\u8001\u306e\u65e5\uff08\u30cf\u30c3\u30d4\u30fc\u30de\u30f3\u30c7\u30fc\uff09";
                }
            } else {
                monthDay2 = new MonthDay(9, 15);
                if (monthDay3.is(monthDay2)) {
                    return "\u656c\u8001\u306e\u65e5";
                }
            }
        } else {
            monthDay2 = new MonthDay(9, 15);
        }
        if (monthDay3.is(monthDay = JapaneseHoliday.getAutumnalEquinoxDay(n))) {
            return "\u79cb\u5206\u306e\u65e5";
        }
        if (n >= 1966) {
            if (n >= 2003) {
                if (monthDay3.is(JapaneseHoliday.getHappyMonday(n, 10, 2))) {
                    return "\u4f53\u80b2\u306e\u65e5\uff08\u30cf\u30c3\u30d4\u30fc\u30de\u30f3\u30c7\u30fc\uff09";
                }
            } else if (monthDay3.is(10, 10)) {
                return "\u4f53\u80b2\u306e\u65e5";
            }
        }
        if (monthDay3.is(11, 3)) {
            return "\u6587\u5316\u306e\u65e5";
        }
        if (monthDay3.is(11, 23)) {
            return "\u52e4\u52b4\u611f\u8b1d\u306e\u65e5";
        }
        if (n >= 1989 && monthDay3.is(12, 23)) {
            return "\u5929\u7687\u8a95\u751f\u65e5";
        }
        if (n >= 1986) {
            if (n < 2007 && monthDay3.is(5, 4)) {
                calendar = Calendar.getInstance();
                calendar.set(n, 4, 4, 0, 0, 0);
                n4 = calendar.get(7);
                if (n4 != 1 && n4 != 2) {
                    return "\u56fd\u6c11\u306e\u4f11\u65e5";
                }
            }
            if (n >= 2003 && monthDay2.day == monthDay.day - 2 && monthDay3.is(monthDay2.month, monthDay2.day + 1)) {
                return "\u56fd\u6c11\u306e\u4f11\u65e5";
            }
        }
        if (n >= 1973) {
            if (n >= 2007 && monthDay3.is(5, 6)) {
                calendar = Calendar.getInstance();
                calendar.set(n, 4, 3, 0, 0, 0);
                n4 = calendar.get(7);
                switch (n4) {
                    case 1: 
                    case 6: 
                    case 7: {
                        return "\u632f\u66ff\u4f11\u65e5";
                    }
                }
            }
            if (JapaneseHoliday.compare(1973, 4, 12, n, n2, n3) >= 0) {
                calendar = Calendar.getInstance();
                calendar.set(n, n2 - 1, n3, 0, 0, 0);
                if (calendar.get(7) == 2) {
                    calendar.add(5, -1);
                    String string = JapaneseHoliday.getHolidayName19480720(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
                    if (!string.equals("")) {
                        return String.format("%s\uff08%s\uff09", "\u632f\u66ff\u4f11\u65e5", string);
                    }
                }
            }
        }
        return "";
    }

    private static MonthDay getHappyMonday(int n, int n2, int n3) {
        int n4;
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2 - 1, 1, 0, 0, 0);
        for (int i = 0; i < 31 && (calendar.get(7) != 2 || (n4 = calendar.get(8)) < n3); ++i) {
            calendar.add(5, 1);
        }
        return new MonthDay(calendar);
    }

    private static String getHolidayName18730101(int n, int n2, int n3) {
        MonthDay monthDay = new MonthDay(n2, n3);
        if (monthDay.is(1, 3)) {
            return "\u5143\u59cb\u796d";
        }
        if (monthDay.is(1, 5)) {
            return "\u65b0\u5e74\u5bb4\u4f1a";
        }
        if (n <= 1912 && monthDay.is(1, 30)) {
            return "\u5b5d\u660e\u5929\u7687\u796d";
        }
        if (monthDay.is(2, 11)) {
            return "\u7d00\u5143\u7bc0";
        }
        if (monthDay.is(4, 3)) {
            return "\u795e\u6b66\u5929\u7687\u796d";
        }
        if (n >= 1912 && n < 1927 && monthDay.is(7, 30)) {
            return "\u660e\u6cbb\u5929\u7687\u796d";
        }
        if (n < 1879 && monthDay.is(9, 17) || n >= 1879 && monthDay.is(10, 17)) {
            return "\u795e\u5617\u796d";
        }
        if (n < 1912 && monthDay.is(11, 3) || n < 1927 && monthDay.is(8, 31) || n >= 1927 && monthDay.is(4, 29)) {
            return "\u5929\u9577\u7bc0";
        }
        if (n >= 1913 && n < 1927 && monthDay.is(10, 31)) {
            return "\u5929\u9577\u7bc0\u795d\u65e5";
        }
        if (monthDay.is(11, 23)) {
            return "\u65b0\u5617\u796d";
        }
        if (n >= 1927 && monthDay.is(12, 25)) {
            return "\u5927\u6b63\u5929\u7687\u796d";
        }
        if (n >= 1878) {
            if (monthDay.is(JapaneseHoliday.getVernalEquinoxDay(n))) {
                return "\u6625\u5b63\u7687\u9748\u796d";
            }
            if (monthDay.is(JapaneseHoliday.getAutumnalEquinoxDay(n))) {
                return "\u79cb\u5b63\u7687\u9748\u796d";
            }
        }
        return "";
    }

    private static MonthDay getVernalEquinoxDay(int n) {
        double d = (double)21.4471f + (double)0.242377f * (double)(n - 1900);
        double d2 = (double)(n - 1900) / 4.0;
        int n2 = (int)Math.floor(d) - (int)Math.floor(d2);
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, 2, 1, 0, 0, 0);
        calendar.add(5, n2 - 1);
        return new MonthDay(calendar.get(2) + 1, calendar.get(5));
    }

    private static MonthDay getAutumnalEquinoxDay(int n) {
        double d = (double)23.8896f + (double)0.242032f * (double)(n - 1900);
        double d2 = (double)(n - 1900) / 4.0;
        int n2 = (int)Math.floor(d) - (int)Math.floor(d2);
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, 8, 1, 0, 0, 0);
        calendar.add(5, n2 - 1);
        return new MonthDay(calendar.get(2) + 1, calendar.get(5));
    }

    private static int compare(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n != n4) {
            return n > n4 ? -1 : 1;
        }
        if (n2 != n5) {
            return n2 > n5 ? -1 : 1;
        }
        if (n3 != n6) {
            return n3 > n6 ? -1 : 1;
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MonthDay
    extends Pair<Integer, Integer> {
        int month;
        int day;

        public MonthDay(Calendar calendar) {
            this(calendar.get(2) + 1, calendar.get(5));
        }

        public MonthDay(int n, int n2) {
            super(n, n2);
            assert (n >= 1 && n <= 12);
            this.month = n;
            this.day = n2;
        }

        boolean is(int n, int n2) {
            return n == this.month && n2 == this.day;
        }

        boolean is(MonthDay monthDay) {
            return this.equals(monthDay);
        }

        public String toString() {
            return this.month + "/" + this.day;
        }
    }
}

