package net.argius.calendar;

import static java.util.Calendar.*;

import java.util.*;

/**
 * iNjB
 * ̔NB
 */
public final class Month {

    private static final Holiday HOLIDAY = Holiday.getInstance();

    private final int year;
    private final int month;

    private List<Day> days;

    /**
     * Month̐B
     * @param year N
     * @param month (1`12)
     */
    public Month(int year, int month) {
        assert month >= 1 && month <= 12;
        this.year = year;
        this.month = month;
        this.days = Collections.unmodifiableList(createDays(year, month));
    }

    /**
     * Xg𐶐B
     * @param year N
     * @param month 
     * @return Xg
     */
    private List<? extends Day> createDays(int year, int month) {
        List<Day> list = new ArrayList<Day>();
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, 1, 0, 0, 0);
        while (c.get(MONTH) == month - 1) {
            list.add(HOLIDAY.getDay(this, c));
            c.add(DAY_OF_MONTH, +1);
        }
        return list;
    }

    /**
     * 擾B
     * @param number \l
     * @return 
     */
    public Day getDay(int number) {
        if (number < 1 || number > days.size()) {
            throw new IllegalArgumentException("number=" + number + ", size=" + days.size());
        }
        return days.get(number - 1);
    }

    /**
     * year̎擾B
     * @return year
     */
    public int getYear() {
        return year;
    }

    /**
     * month̎擾B
     * @return month
     */
    public int getMonth() {
        return month;
    }

    /**
     * days̎擾B
     * @return days
     */
    public List<Day> getDays() {
        return days;
    }

    /* @see java.lang.Object#toString() */
    @Override
    public String toString() {
        return String.format("%04d-%02d", year, month);
    }

}
