package net.argius;

import static java.util.Calendar.*;
import static net.argius.calendar.Resource.getString;

import java.io.*;
import java.text.*;
import java.util.*;

import net.argius.calendar.*;

/**
 * jJ_[B
 */
public final class Calendar {

    private static final String BUNDLE_NAME = "net.argius.calendar.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);

    /**
     * Calendar̐B
     */
    private Calendar() {
        // empty
    }

    /**
     * J_[o͂B
     * @param year N
     * @param month  (1`12ȊȌꍇ͖wƂ݂Ȃ)
     */
    public static void print(int year, int month) {
        print(new PrintWriter(System.out, true), year, month);
    }

    /**
     * J_[o͂B
     * @param out o͐
     * @param year N
     * @param month 
     */
    public static void print(PrintWriter out, int year, int month) {
        Month m = new Month(year, month);
        out.println("---------------------------");
        out.println(getMonthString(year, month));
        for (DayOfWeek w : DayOfWeek.values()) {
            String s = w.getLocalizedString();
            int length = s.getBytes().length;
            boolean gapped = s.length() != length;
            if (gapped) {
                String x = s.substring(s.length() - 1, s.length());
                out.printf(" %s ", x); // for multibyte char
            } else {
                out.printf("%3s ", s);
            }
        }
        out.println();
        out.println("--- --- --- --- --- --- ---");
        int filledCount = 0;
        int top = m.getDay(1).getDayOfWeek().ordinal();
        int spaceWidth = top * 4;
        if (spaceWidth > 0) {
            out.printf("%" + spaceWidth + "s", "");
        }
        filledCount += top;
        for (Day day : m.getDays()) {
            int number = day.getNumber();
            if (day.isHoliday()) {
                out.printf("*%2d*", number);
            } else {
                out.printf(" %2d ", number);
            }
            if (day.getDayOfWeek() == DayOfWeek.Saturday) {
                out.println();
            }
        }
        filledCount += m.getDays().size();
        if (filledCount < 35) {
            out.println();
        }
        out.println();
        out.println("---------------------------");
        out.flush();
    }

    /**
     * N̕擾B
     * P[ɂătH[}bg͈قȂB
     * @param year N
     * @param month 
     * @return N
     */
    private static String getMonthString(int year, int month) {
        String format = RESOURCE_BUNDLE.getString("cui.monthformat");
        java.util.Calendar c = java.util.Calendar.getInstance();
        c.set(year, month - 1, 1);
        return String.format(format, c);
    }

    /**
     * Gg|CgB
     * @param args IvVorp[^
     */
    public static void main(String... args) {
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (arg.equals("--gui")) {
                    WindowView.main(args);
                    return;
                } else if (arg.startsWith("-v") || arg.startsWith("--version")) {
                    String s = MessageFormat.format(getString("main.about"), Resource.getVersion());
                    System.out.println(s);
                    return;
                } else {
                    throw new IllegalArgumentException("bad option: " + arg);
                }
            }
        }
        try {
            if (args.length > 0) {
                int year = Integer.parseInt(args[0]);
                if (args.length == 1) {
                    for (int i = 0; i < 4; i++) {
                        Writer w1 = new StringWriter();
                        Writer w2 = new StringWriter();
                        Writer w3 = new StringWriter();
                        print(new PrintWriter(w1, true), year, i * 3 + 1);
                        print(new PrintWriter(w2, true), year, i * 3 + 2);
                        print(new PrintWriter(w3, true), year, i * 3 + 3);
                        Scanner scan1 = new Scanner(new StringReader(w1.toString()));
                        Scanner scan2 = new Scanner(w2.toString());
                        Scanner scan3 = new Scanner(w3.toString());
                        int c = 0;
                        while (scan1.hasNextLine() && scan2.hasNextLine() && scan3.hasNextLine()) {
                            ++c;
                            String line1, line2, line3;
                            if (c == 2 || c == 3) {
                                line1 = scan1.nextLine();
                                line2 = scan2.nextLine();
                                line3 = scan3.nextLine();
                            } else {
                                line1 = String.format("%-28s", scan1.nextLine());
                                line2 = String.format("%-28s", scan2.nextLine());
                                line3 = String.format("%-28s", scan3.nextLine());
                            }
                            System.out.printf("%s %s %s%n", line1, line2, line3);
                        }
                    }
                } else {
                    print(year, Integer.parseInt(args[1]));
                }
            } else {
                java.util.Calendar c = java.util.Calendar.getInstance();
                int year = c.get(YEAR);
                if (args.length == 1) {
                    print(year, 0);
                } else {
                    print(year, c.get(MONTH) + 1);
                }
            }
        } catch (RuntimeException ex) {
            ex.printStackTrace(System.out);
            System.out.println("invalid parameters, cause of: " + ex);
        }
    }

}
