package net.argius.version;

import java.io.*;
import java.text.*;
import java.util.*;

/**
 * o[Wt@Cc[B
 */
public final class VersionFile {

    private static final String PREFIX = "version.";
    private static final String KEY_MAJOR = PREFIX + "major";
    private static final String KEY_MINOR = PREFIX + "minor";
    private static final String KEY_REVISION = PREFIX + "revision";
    private static final String KEY_NOTE = PREFIX + "note";
    private static final String KEY_BUILD_NUMBER = PREFIX + "build.number";
    private static final String KEY_BUILD_TIME = PREFIX + "build.time";
    private static final String EQ = " = ";

    private File file;
    private Version version;

    /**
     * VersionFile̐B
     * @param file o[Wlt@C
     * @throws IOException o̓G[ꍇ 
     */
    public VersionFile(File file) throws IOException {
        Properties props = new Properties();
        InputStream is = new FileInputStream(file);
        try {
            props.load(is);
        } finally {
            is.close();
        }
        this.file = file;
        this.version = Version.getInstance(getInt(props, KEY_MAJOR),
                                           getInt(props, KEY_MINOR),
                                           getInt(props, KEY_REVISION),
                                           props.getProperty(KEY_NOTE),
                                           getInt(props, KEY_BUILD_NUMBER),
                                           Long.parseLong(props.getProperty(KEY_BUILD_TIME)));
    }

    /**
     * o[W̉ZB
     * rhԍ͏+1ZB
     * @param incMajor W[o[W̉Z
     * @param incMinor }Ci[o[W̉Z
     * @param incRevision rW̉Z
     * @param incNote l̉Z
     * @throws IOException o̓G[ꍇ
     */
    private void incrementVersion(int incMajor,
                                  int incMinor,
                                  int incRevision,
                                  int incNote) throws IOException {
        saveFile(version.getMajorNumber() + incMajor,
                 version.getMinorNumber() + incMinor,
                 version.getRevision() + incRevision,
                 getTodayString(),
                 version.getBuildNumber() + 1,
                 System.currentTimeMillis());
    }

    /**
     * o[W̍XVB
     * @param buildNumber rhԍ
     * @param buildTime rh
     * @throws IOException o̓G[ꍇ
     */
    private void update(int buildNumber, Date buildTime) throws IOException {
        saveFile(version.getMajorNumber(),
                 version.getMinorNumber(),
                 version.getRevision(),
                 getTodayString(),
                 buildNumber,
                 buildTime.getTime());
    }

    /**
     * t̕擾B
     * @return t̕
     */
    private static String getTodayString() {
        return new SimpleDateFormat("yyyyMMdd").format(new Date());
    }

    /**
     * vpeB𐮐lƂĎ擾B
     * @param props vpeB
     * @param key L[
     * @return l
     */
    private static int getInt(Properties props, String key) {
        return Integer.parseInt(props.getProperty(key));
    }

    /**
     * t@CۑB
     * @param majorNumber
     * @param minorNumber
     * @param revision
     * @param note
     * @param buildNumber
     * @param buildTime
     * @throws IOException
     */
    private void saveFile(int majorNumber,
                          int minorNumber,
                          int revision,
                          String note,
                          int buildNumber,
                          long buildTime) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(file));
        try {
            out.println(KEY_MAJOR + EQ + majorNumber);
            out.println(KEY_MINOR + EQ + minorNumber);
            out.println(KEY_REVISION + EQ + revision);
            if (note != null) {
                out.println(KEY_NOTE + EQ + note);
            }
            out.println(KEY_BUILD_NUMBER + EQ + buildNumber);
            out.println(KEY_BUILD_TIME + EQ + buildTime);
        } finally {
            out.close();
        }
    }

    /**
     * NB
     * @param args 
     *         [0] : o[Wt@C
     *         [1] : W[o[W̉Z
     *         [2] : }Ci[o[W̉Z
     *         [3] : rW̉Z
     *         [4] : l̉Z
     *         [5] : (optional) rhԍ
     *         [6] : (optional) rhID YYYY-MM-DD_hh-mm-ss
     * @throws IOException o̓G[ꍇ
     * @throws ParseException p[XG[ꍇ
     */
    public static void main(String[] args) throws IOException, ParseException {
        int index = 0;
        File file = new File(args[index++]);
        int incMajor = Integer.parseInt(args[index++]);
        int incMinor = Integer.parseInt(args[index++]);
        int incRevision = Integer.parseInt(args[index++]);
        int incNote = Integer.parseInt(args[index++]);
        VersionFile vf = new VersionFile(file);
        if (args.length > index + 1) {
            int buildNumber = Integer.parseInt(args[index++]);
            Date buildTime = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").parse(args[index++]);
            vf.update(buildNumber, buildTime);
        } else {
            vf.incrementVersion(incMajor, incMinor, incRevision, incNote);
        }
    }

}