package net.argius.calendar;

import java.awt.*;
import java.util.*;
import java.util.Map.*;

import javax.swing.*;
import javax.swing.UIDefaults.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

/**
 * tHgɂLaFB
 */
final class MonospacedFontLookAndFeel extends BasicLookAndFeel {

    private LookAndFeel base;

    /**
     * MonospacedFontLookAndFeel̐B
     * @param base bƂȂLaF
     */
    MonospacedFontLookAndFeel(LookAndFeel base) {
        this.base = base;
    }

    /**
     * LaFCXg[B
     */
    static void install() {
        LookAndFeel laf = new MonospacedFontLookAndFeel(UIManager.getLookAndFeel());
        try {
            UIManager.setLookAndFeel(laf);
        } catch (UnsupportedLookAndFeelException ex) {
            throw new IllegalStateException(ex.toString());
        }
    }

    /* (overridden)
     * @see javax.swing.plaf.basic.BasicLookAndFeel#getDefaults()
     */
    public UIDefaults getDefaults() {
        UIDefaults defaults = base.getDefaults();
        for (Iterator it = defaults.entrySet().iterator(); it.hasNext();) {
            Entry entry = (Entry)it.next();
            Object key = entry.getKey();
            if (String.valueOf(key).endsWith("font")) {
                Object value = entry.getValue();
                if (value instanceof UIDefaults.ActiveValue) {
                    ActiveValue activeValue = (ActiveValue)value;
                    entry.setValue(new FontChangingActiveValue(activeValue));
                }
            }
        }
        return defaults;
    }

    /* (overridden)
     * @see javax.swing.LookAndFeel#getDescription()
     */
    public String getDescription() {
        return base.getDescription();
    }

    /* (overridden)
     * @see javax.swing.LookAndFeel#getID()
     */
    public String getID() {
        return base.getID();
    }

    /* (overridden)
     * @see javax.swing.LookAndFeel#getName()
     */
    public String getName() {
        return base.getName();
    }

    /* (overridden)
     * @see javax.swing.LookAndFeel#isNativeLookAndFeel()
     */
    public boolean isNativeLookAndFeel() {
        return false;
    }

    /* (overridden)
     * @see javax.swing.LookAndFeel#isSupportedLookAndFeel()
     */
    public boolean isSupportedLookAndFeel() {
        return base.isSupportedLookAndFeel();
    }

    /**
     * tHgύXActiveValueB
     */
    private static final class FontChangingActiveValue implements ActiveValue {

        private ActiveValue base;

        /**
         * FontChangingActiveValue̐B
         * @param base
         */
        FontChangingActiveValue(ActiveValue base) {
            this.base = base;
        }

        /* (overridden)
         * @see javax.swing.UIDefaults$ActiveValue#createValue(javax.swing.UIDefaults)
         */
        public Object createValue(UIDefaults table) {
            Object o = base.createValue(table);
            if (o instanceof FontUIResource) {
                FontUIResource r = (FontUIResource)o;
                String family = "Monospaced";
                int style = Font.PLAIN;
                return new FontUIResource(family, style, r.getSize());
            } else {
                return o;
            }
        }

    }

}
