/*
 * Decompiled with CFR 0.152.
 */
package net.argius.calendar;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.argius.calendar.CacheMap;
import net.argius.calendar.Day;

class Holiday {
    private Map cache = new CacheMap();

    Holiday() {
    }

    Day getDay(Calendar calendar) {
        Entry entry;
        Integer n = new Integer(calendar.get(1));
        Map map = (Map)this.cache.get(n);
        if (map == null) {
            map = this.createNewHolidayMap(n);
            this.cache.put(n, new HashMap(map));
        }
        if (map.containsKey(entry = new Entry(calendar))) {
            String string = (String)map.get(entry);
            return new Day(calendar, true, string);
        }
        return new Day(calendar);
    }

    private Entry getVernalEquinoxDay(int n) {
        double d = 21.4471f;
        double d2 = 0.242377f;
        double d3 = d + d2 * (double)(n - 1900);
        double d4 = (n - 1900) / 4;
        double d5 = Math.floor(d3) - Math.floor(d4);
        return new Entry(3, (int)d5);
    }

    private Entry getAutumnalEquinoxDay(int n) {
        double d = 23.8896f;
        double d2 = 0.242032f;
        double d3 = d + d2 * (double)(n - 1900);
        double d4 = (n - 1900) / 4;
        double d5 = Math.floor(d3) - Math.floor(d4);
        return new Entry(9, (int)d5);
    }

    private Entry getHappyMonday(int n, int n2, int n3) {
        int n4;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, 1);
        for (int i = 0; i < 31 && (gregorianCalendar.get(7) != 2 || (n4 = gregorianCalendar.get(8)) < n3); ++i) {
            ((Calendar)gregorianCalendar).add(5, 1);
        }
        return new Entry(gregorianCalendar);
    }

    private Map createNewHolidayMap(int n) {
        HashMap<Entry, String> hashMap = new HashMap<Entry, String>();
        if (n >= 1949) {
            Cloneable cloneable;
            int n2;
            hashMap.put(new Entry(1, 1), "\u5143\u65e6");
            if (n >= 2000) {
                hashMap.put(this.getHappyMonday(n, 1, 2), "\u6210\u4eba\u306e\u65e5\uff08\u30cf\u30c3\u30d4\u30fc\u30de\u30f3\u30c7\u30fc\uff09");
            } else {
                hashMap.put(new Entry(1, 15), "\u6210\u4eba\u306e\u65e5");
            }
            if (n >= 1967) {
                hashMap.put(new Entry(2, 11), "\u5efa\u56fd\u8a18\u5ff5\u306e\u65e5");
            }
            hashMap.put(this.getVernalEquinoxDay(n), "\u6625\u5206\u306e\u65e5");
            Entry entry = new Entry(4, 29);
            if (n >= 2007) {
                hashMap.put(entry, "\u662d\u548c\u306e\u65e5");
            } else if (n >= 1989) {
                hashMap.put(entry, "\u307f\u3069\u308a\u306e\u65e5");
            } else {
                hashMap.put(entry, "\u5929\u7687\u8a95\u751f\u65e5");
            }
            hashMap.put(new Entry(5, 3), "\u61b2\u6cd5\u8a18\u5ff5\u65e5");
            if (n >= 2007) {
                hashMap.put(new Entry(5, 4), "\u307f\u3069\u308a\u306e\u65e5");
            }
            hashMap.put(new Entry(5, 5), "\u5b50\u4f9b\u306e\u65e5");
            if (n >= 1996) {
                if (n >= 2003) {
                    hashMap.put(this.getHappyMonday(n, 7, 3), "\u6d77\u306e\u65e5\uff08\u30cf\u30c3\u30d4\u30fc\u30de\u30f3\u30c7\u30fc\uff09");
                } else {
                    hashMap.put(new Entry(7, 19), "\u6d77\u306e\u65e5");
                }
            }
            Entry entry2 = null;
            if (n >= 1966) {
                if (n >= 2003) {
                    entry2 = this.getHappyMonday(n, 9, 3);
                    hashMap.put(entry2, "\u656c\u8001\u306e\u65e5\uff08\u30cf\u30c3\u30d4\u30fc\u30de\u30f3\u30c7\u30fc\uff09");
                } else {
                    entry2 = new Entry(9, 15);
                    hashMap.put(entry2, "\u656c\u8001\u306e\u65e5");
                }
            }
            Entry entry3 = this.getAutumnalEquinoxDay(n);
            hashMap.put(entry3, "\u79cb\u5206\u306e\u65e5");
            if (n >= 1966) {
                if (n >= 2003) {
                    hashMap.put(this.getHappyMonday(n, 10, 2), "\u4f53\u80b2\u306e\u65e5\uff08\u30cf\u30c3\u30d4\u30fc\u30de\u30f3\u30c7\u30fc\uff09");
                } else {
                    hashMap.put(new Entry(10, 10), "\u4f53\u80b2\u306e\u65e5");
                }
            }
            hashMap.put(new Entry(11, 3), "\u6587\u5316\u306e\u65e5");
            hashMap.put(new Entry(11, 23), "\u52e4\u52b4\u611f\u8b1d\u306e\u65e5");
            if (n >= 1989) {
                hashMap.put(new Entry(12, 23), "\u5929\u7687\u8a95\u751f\u65e5");
            }
            if (n >= 1986 && n < 2007 && (n2 = ((Calendar)(cloneable = new GregorianCalendar(n, 4, 4))).get(7)) != 1 && n2 != 2) {
                hashMap.put(new Entry(5, 4), "\u56fd\u6c11\u306e\u4f11\u65e5");
            }
            if (n >= 2003 && entry2 != null && entry2.date == entry3.date - 2) {
                hashMap.put(new Entry(9, entry2.date + 1), "\u56fd\u6c11\u306e\u4f11\u65e5");
            }
            if (n >= 1973) {
                cloneable = new HashMap();
                Calendar calendar = Calendar.getInstance();
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Entry entry4;
                    Entry entry5 = (Entry)iterator.next();
                    int n3 = entry5.month;
                    int n4 = entry5.date;
                    if (n == 1973 && (n3 < 4 || n3 == 4 && n4 < 12)) continue;
                    calendar.clear();
                    calendar.set(n, n3 - 1, n4);
                    if (calendar.get(7) != 1 || hashMap.containsKey(entry4 = new Entry(n3, n4 + 1))) continue;
                    cloneable.put(entry4, "\u632f\u66ff\u4f11\u65e5");
                }
                if (n >= 2007) {
                    calendar.clear();
                    calendar.set(n, 4, 3);
                    int n5 = calendar.get(7);
                    switch (n5) {
                        case 1: 
                        case 6: 
                        case 7: {
                            cloneable.put(new Entry(5, 6), "\u632f\u66ff\u4f11\u65e5");
                            break;
                        }
                    }
                }
                hashMap.putAll((Map<Entry, String>)((Object)cloneable));
            }
        } else {
            hashMap.put(this.getVernalEquinoxDay(n), "\u6625\u5206\u306e\u65e5 (\u795d\u65e5\uff1f)");
            hashMap.put(this.getAutumnalEquinoxDay(n), "\u79cb\u5206\u306e\u65e5 (\u795d\u65e5\uff1f)");
        }
        return hashMap;
    }

    private static class Entry {
        int month;
        int date;

        Entry(int n, int n2) {
            this.month = n;
            this.date = n2;
        }

        Entry(Calendar calendar) {
            this.month = calendar.get(2) + 1;
            this.date = calendar.get(5);
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                return this.month == entry.month && this.date == entry.date;
            }
            return false;
        }

        public int hashCode() {
            return this.month * 32 + this.date;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.month);
            stringBuffer.append('/');
            stringBuffer.append(this.date);
            return stringBuffer.toString();
        }
    }
}

