package net.argius;

import java.util.*;

import net.argius.calendar.*;
import net.argius.version.*;

/**
 * {̏jJ_[B
 */
public final class Calendar {

    /**
     * @param args
     */
    public static void main(String[] args) {
        String localeString = String.valueOf(Locale.getDefault());
        if (!localeString.equals("ja_JP")) {
            throw new UnsupportedOperationException("Japanese Only : current locale = "
                                                    + localeString);
        }
        List argList = Arrays.asList(args);
        if (argList.contains("-v") || argList.contains("--version")) {
            System.out.println("argius Calendar - version "
                               + Version.getInstance(Month.class)
                                        .getFullString());
        } else if (argList.contains("-g") || argList.contains("--gui")) {
            GraphicView.main(args);
        } else {
            ConsoleView.main(args);
        }
    }

}
