/*
 * Decompiled with CFR 0.152.
 */
package net.argius.version;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;

public final class Version
implements Serializable,
Comparable,
Cloneable {
    private static final long serialVersionUID = -8929616242785956174L;
    private static final String EMPTY_STRING = "";
    private static final String PREFIX = "version.";
    private static final String FILE_NAME = "version.properties";
    private static final String KEY_MAJOR = "version.major";
    private static final String KEY_MINOR = "version.minor";
    private static final String KEY_REVISION = "version.revision";
    private static final String KEY_NOTE = "version.note";
    private static final String KEY_BUILD_NUMBER = "version.build.number";
    private static final String KEY_BUILD_TIME = "version.build.time";
    private transient String shortString;
    private transient String regularString;
    private transient String fullString;
    private final boolean valid;
    private final int majorNumber;
    private final int minorNumber;
    private final int revision;
    private final String note;
    private final int buildNumber;
    private final long buildTime;

    private Version(int n, int n2, int n3, String string, int n4, long l) {
        if (n < 0) {
            throw new IllegalArgumentException("majorNumber : " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("minorNumber : " + n2);
        }
        this.majorNumber = n;
        this.minorNumber = n2;
        this.revision = n3;
        this.note = string == null ? EMPTY_STRING : string;
        this.buildNumber = n4;
        this.buildTime = l;
        this.initializeString();
        this.valid = true;
    }

    private Version() {
        this.majorNumber = 0;
        this.minorNumber = 0;
        this.revision = 0;
        this.note = EMPTY_STRING;
        this.buildNumber = 0;
        this.buildTime = 0L;
        this.shortString = EMPTY_STRING;
        this.regularString = EMPTY_STRING;
        this.fullString = EMPTY_STRING;
        this.valid = false;
    }

    private void initializeString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.majorNumber);
        stringBuffer.append('.');
        stringBuffer.append(this.minorNumber);
        this.shortString = stringBuffer.toString();
        stringBuffer.append('.');
        stringBuffer.append(this.revision);
        stringBuffer.append(' ');
        stringBuffer.append(this.note);
        this.regularString = stringBuffer.toString();
        if (this.note.length() > 0) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("[build #");
        stringBuffer.append(this.buildNumber);
        stringBuffer.append(' ');
        stringBuffer.append(new Date(this.buildTime));
        stringBuffer.append(']');
        this.fullString = stringBuffer.toString();
    }

    public static Version getInstance(int n, int n2) {
        return Version.getInstance(n, n2, 0, EMPTY_STRING, Integer.MIN_VALUE, Long.MIN_VALUE);
    }

    public static Version getInstance(int n, int n2, int n3, String string, int n4, long l) {
        try {
            return new Version(n, n2, n3, string, n4, l);
        }
        catch (Exception exception) {
            return new Version();
        }
    }

    public static Version getInstance(Class clazz) {
        try {
            InputStream inputStream = clazz.getResourceAsStream(FILE_NAME);
            Properties properties = new Properties();
            properties.load(inputStream);
            String string = properties.getProperty(KEY_BUILD_NUMBER);
            String string2 = properties.getProperty(KEY_BUILD_TIME);
            return new Version(Integer.parseInt(properties.getProperty(KEY_MAJOR)), Integer.parseInt(properties.getProperty(KEY_MINOR)), Integer.parseInt(properties.getProperty(KEY_REVISION)), properties.getProperty(KEY_NOTE), string == null ? Integer.MIN_VALUE : Integer.parseInt(string), string2 == null ? Long.MIN_VALUE : Long.parseLong(string2));
        }
        catch (IOException iOException) {
            return new Version();
        }
        catch (RuntimeException runtimeException) {
            return new Version();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getMajorNumber() {
        return this.majorNumber;
    }

    public int getMinorNumber() {
        return this.minorNumber;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getNote() {
        return this.note;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public String getShortString() {
        return this.shortString;
    }

    public String getRegularString() {
        return this.regularString;
    }

    public String getFullString() {
        return this.fullString;
    }

    private Object readResolve() throws ObjectStreamException {
        return Version.getInstance(this.majorNumber, this.minorNumber, this.revision, this.note, this.buildNumber, this.buildTime);
    }

    public int compareTo(Version version) {
        if (version.valid != this.valid) {
            return this.valid ? -1 : 1;
        }
        return this.fullString.compareTo(version.fullString);
    }

    public int compareTo(Object object) {
        return this.compareTo((Version)object);
    }

    public Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        if (object instanceof Version) {
            return object;
        }
        throw new CloneNotSupportedException();
    }

    public boolean equals(Object object) {
        if (object instanceof Version) {
            Version version = (Version)object;
            return version.valid == this.valid && version.getFullString().equals(this.fullString);
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + (this.valid ? 0 : 1);
        n = 37 * n + this.fullString.hashCode();
        return n;
    }

    public String toString() {
        return this.fullString;
    }
}

