package net.argius.calendar;

import java.util.*;

/**
 * J_[ׂ̈̌\NXłB
 * <br><br>
 * ̃NX̃CX^X́A̔NɊ܂܂t
 * <code>Day</code>IuWFNgƂĕۗL܂B
 * @see Day
 */
public final class Month {

    // LbV
    private static Map cache = new CacheMap();

    private GregorianCalendar calendar;
    private List days;

    /**
     * IuWFNg𐶐܂B
     * @param calendar t
     */
    private Month(Calendar calendar) {

        /*
                // s̏j@̂݃T|[g
                if (calendar.get(Calendar.YEAR) < 1949) {
                    throw new IllegalArgumentException("1949NȌj̓T|[gĂ܂");
                }
         */

        // OSItɂĂ
        int year = calendar.get(Calendar.YEAR);
        int month = calendar.get(Calendar.MONTH);
        this.calendar = new GregorianCalendar(year,
                                              month,
                                              calendar.get(Calendar.DATE));

        // jXg쐬
        Holiday holiday = new Holiday();

        // ̍쐬
        days = new ArrayList();
        for (int day = 1, n = getNumberOfDays(); day <= n; day++) {
            Calendar date = new GregorianCalendar(year, month, day);
            days.add(holiday.getDay(date));
        }

    }

    /**
     * ̃IuWFNgt̔N\lԂ܂B
     * @return N\l
     */
    public int getYearNumber() {

        return calendar.get(Calendar.YEAR);

    }

    /**
     * ̃IuWFNgť\lԂ܂B
     * @return \l
     */
    public int getMonthNumber() {

        return calendar.get(Calendar.MONTH) + 1;

    }

    /**
     * w肵tԂ܂B
     * @param day (l)
     * @return t
     */
    public Day getDay(int day) {

        return (Day)days.get(day - 1);

    }

    /**
     * ̓Ԃ܂B
     * @return ̌̓
     */
    public int getNumberOfDays() {

        int month = calendar.get(Calendar.MONTH);

        switch (month) {
            case Calendar.FEBRUARY:
                return 28 + (isLeapYear() ? 1 : 0);
            case Calendar.APRIL:
            case Calendar.JUNE:
            case Calendar.SEPTEMBER:
            case Calendar.NOVEMBER:
                return 30;
            default:
                return 31;
        }

    }

    /**
     * ̔N[Nǂׂ܂B
     * @return [NȂ<code>true</code>AłȂ<code>false</code>
     */
    public boolean isLeapYear() {

        return calendar.isLeapYear(getYearNumber());

    }

    /**
     * ̃IuWFNg̎w肵Ό\CX^XԂ܂B
     * @param distance Βl
     * @return w肳ꂽ̃CX^X
     */
    public Month getRelative(int distance) {

        Calendar newCalendar = Calendar.getInstance();
        newCalendar.setTime(calendar.getTime());
        newCalendar.add(Calendar.MONTH, distance);
        return getInstance(newCalendar);

    }

    /**
     * ݂̔ÑCX^X擾܂B
     * @return w肳ꂽ̃CX^X
     */
    public static Month getInstance() {

        return getInstance(Calendar.getInstance());

    }

    /**
     * w肳ꂽÑCX^X擾܂B
     * @param year N(l)
     * @param month (l)
     * @param calendar tIuWFNg
     * @return w肳ꂽ̃CX^X
     */
    public static Month getInstance(int year, int month) {

        return getInstance(new GregorianCalendar(year, month - 1, 1));

    }

    /**
     * w肳ꂽtIuWFNgÑCX^X擾܂B
     * @param calendar tIuWFNg
     * @return w肳ꂽ̃CX^X
     */
    public static Month getInstance(Calendar calendar) {

        int year = calendar.get(Calendar.YEAR);
        int month = calendar.get(Calendar.MONTH) + 1;

        String key = String.valueOf(year * 100 + month);
        Month instance = (Month)cache.get(key);

        if (instance == null) {
            // VăLbV
            instance = new Month(calendar);
            cache.put(key, instance);
        }

        return instance;

    }

    /**
     * ̃IuWFNg̕\Ԃ܂B
     * @return \
     */
    public String toString() {

        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        switch (calendar.get(Calendar.ERA)) {
            case GregorianCalendar.BC:
                sb.append("IO ");
                break;
        }
        sb.append(calendar.get(Calendar.YEAR));
        sb.append("N ");
        sb.append(calendar.get(Calendar.MONTH) + 1);
        sb.append("");
        return sb.toString();

    }

}
