package net.argius.calendar;

import java.util.*;

/**
 * gȂȂGgIɍ폜}bv̎łB
 * <br><br>
 * }bsOꂽvf̃L[́AɎQƃXgɓo^܂B
 * ̃L[́AANZXƎQƃXg̍ŌɈړ܂B
 * QƃXǵA}bsO̗vfeʂzƂAXǧÂA
 * ܂擪Ŝ̂悻10%̗vfXg폜܂B
 * Xg폜ꂽvf́A}bsO폜܂B
 */
class CacheMap extends AbstractMap {

    private static final int DEFAULT_CAPACITY = 36;

    private int capacity;
    private int deleteRange;
    private Map map;
    private List reference;

    /**
     * LbV}bv𐶐܂B
     */
    CacheMap() {

        this(DEFAULT_CAPACITY);

    }

    /**
     * w肵eʂLbV}bv𐶐܂B
     * @param limit e
     */
    CacheMap(int initialCapacity) {

        if (capacity > 0) {
            this.capacity = initialCapacity;
        } else {
            this.capacity = DEFAULT_CAPACITY;
        }

        deleteRange = Math.round(this.capacity * 0.1f) + 1;

        map = new HashMap(this.capacity);
        reference = new ArrayList();

    }

    /**
     * svȃLbV𐮗܂B
     * @param key ŋߎgꂽL[
     */
    private void clean(Object key) {

        reference.remove(key);
        reference.add(key);

        int size = reference.size();
        if (size > capacity) {
            for (int i = 0; i < deleteRange; i++) {
                Object deleted = reference.remove(0);
                map.remove(deleted);
            }
        }

    }

    /**
     * w肵L[Ƀ}bsOꂽl擾܂B
     * @param key L[
     * @return l
     */
    public Object get(Object key) {

        clean(key);
        return map.get(key);

    }

    /**
     * lw肵L[Ń}bsO܂B
     * @param key L[
     * @param value l
     * @return Âl
     */
    public Object put(Object key, Object value) {

        clean(key);
        return map.put(key, value);

    }

    /**
     * ̃}bvɃ}bvƒǉ܂B
     * @param t ʂ̃}bv
     */
    public void putAll(Map t) {

        for (Iterator it = t.keySet().iterator(); it.hasNext();) {
            Object key = it.next();
            Object value = t.get(key);
            put(key, value);
        }

    }

    /**
     * w肵L[̃}bsOj܂B
     * @param key L[
     * @return 폜ꂽl
     */
    public Object remove(Object key) {

        reference.remove(key);
        return map.remove(key);

    }

    /**
     * ׂẴ}bsO܂B
     */
    public void clear() {

        map.clear();
        reference.clear();

    }

    /**
     * }bvɎw肵L[܂܂Ă邩ׂ܂B
     * @param key L[
     * @return w肵L[܂܂Ă<code>true</code>AłȂ<code>false</code>
     */
    public boolean containsKey(Object key) {

        return map.containsKey(key);

    }

    /**
     * }bvɎw肵l܂܂Ă邩ׂ܂B
     * @param value l
     * @return w肵l܂܂Ă<code>true</code>AłȂ<code>false</code>
     */
    public boolean containsValue(Object value) {

        return map.containsValue(value);

    }

    /**
     * ̃}bv󂩂ǂ𒲂ׂ܂B
     * @return Ȃ<code>true</code>AłȂ<code>false</code>
     */
    public boolean isEmpty() {

        return map.isEmpty();

    }

    /**
     * }bvɊ܂܂SẴL[ZbgƂĕԂ܂B
     * @return L[̃Zbg
     */
    public Set keySet() {

        return map.keySet();

    }

    /**
     * }bvɊ܂܂SĂ̒lZbgƂĕԂ܂B
     * @return l̃Zbg
     */
    public Collection values() {

        return map.values();

    }

    /**
     * }bṽGgZbgƂĕԂ܂B
     * @return Gg̃Zbg
     */
    public Set entrySet() {

        return map.entrySet();

    }

    /**
     * ̃}bṽTCYԂ܂B
     * @return TCY
     */
    public int size() {

        return map.size();

    }

    /**
     * ʂ̃IuWFNgƓ𒲂ׂ܂B
     * @param o ʂ̃}bvIuWFNg
     * @return <code>true</code>AłȂ<code>false</code>
     */
    public boolean equals(Object o) {

        if (o instanceof CacheMap) {

            return o == this;

        }

        return false;

    }

    /**
     * ̃}bv̕\Ԃ܂B
     * @return \
     */
    public String toString() {

        return map.toString();

    }

}
