package net.argius.calendar;

import java.util.*;

import junit.framework.*;

/**
 * 
 */
public class HolidayTest extends TestCase {

    private Holiday instance;

    /* (overridden)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        this.instance = new Holiday();
    }

    /**
     * j̃eXgB
     */
    public void testHolidayName() {
        checkHoliday(2007, 12, 24, "U֋x");
        checkHoliday(2008, 5, 5, "q̓");
        checkHoliday(2008, 5, 6, "U֋x");
        checkHoliday(2009, 9, 22, "̋x");
    }

    /**
     * j`FbNB
     * @param year N
     * @param month 
     * @param date 
     * @param expect zl
     */
    private void checkHoliday(int year, int month, int date, String expect) {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(year, month - 1, date);
        Day day = instance.getDay(c);
        assertEquals(expect, day.getHolidayName());
    }

}
