/*
 * Decompiled with CFR 0.152.
 */
package net.argius.calendar;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CacheMap
extends AbstractMap {
    private static final int DEFAULT_CAPACITY = 36;
    private int capacity;
    private int deleteRange;
    private Map map;
    private List reference;

    CacheMap() {
        this(36);
    }

    CacheMap(int n) {
        this.capacity = this.capacity > 0 ? n : 36;
        this.deleteRange = Math.round((float)this.capacity * 0.1f) + 1;
        this.map = new HashMap(this.capacity);
        this.reference = new ArrayList();
    }

    private void clean(Object object) {
        this.reference.remove(object);
        this.reference.add(object);
        int n = this.reference.size();
        if (n > this.capacity) {
            for (int i = 0; i < this.deleteRange; ++i) {
                Object e = this.reference.remove(0);
                this.map.remove(e);
            }
        }
    }

    public Object get(Object object) {
        this.clean(object);
        return this.map.get(object);
    }

    public Object put(Object object, Object object2) {
        this.clean(object);
        return this.map.put(object, object2);
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            this.put(k, v);
        }
    }

    public Object remove(Object object) {
        this.reference.remove(object);
        return this.map.remove(object);
    }

    public void clear() {
        this.map.clear();
        this.reference.clear();
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public boolean equals(Object object) {
        if (object instanceof CacheMap) {
            return object == this;
        }
        return false;
    }

    public String toString() {
        return this.map.toString();
    }
}

