package calendar.view;

import java.io.PrintStream;
import java.util.Calendar;

import calendar.core.Day;
import calendar.core.Month;

/**
 * R\[\p̃J_[r[łB 
 */
public final class ConsoleView {
    
    private static final PrintStream out = System.out;
    
    private static final String TITLE = "{̏jJ_[";
    private static final String INDENT = "  ";
    
    public static void main(String[] args) {
        
        // IuWFNg琶
        Month month;
        if (args.length < 2) {
            month = Month.getInstance();
        } else {
            int yearInt  = Integer.parseInt(args[0]);
            int monthInt = Integer.parseInt(args[1]);
            month = Month.getInstance(yearInt, monthInt);
        }
        
        // o\
        out.println(TITLE);
        out.println();
        out.println(month);
        out.println("===============================");
        out.println();
        
        out.println(INDENT + "             y");
        out.println(INDENT + "=== === === === === === === ");
        
        // PT̏
        int firstSaturday = 7;
        for (int i = 1, n = month.getNumberOfDays(); i <= n; i++) {
            
            // ŏ̓yjo
            Day day = month.getDay(i);
            if (day.getDayOfWeek() == Calendar.SATURDAY) {
                firstSaturday = i;
                break;
            }
            
        }
        out.print(INDENT);
        
        // P܂ł̃Xy[X𖄂߂
        int spaceSize = 7 - firstSaturday;
        if (spaceSize != 0) {
            for (int i = 0; i < spaceSize; i++) {
                out.print("    ");
            }
        }
        
        // t\
        for (int i = 1, n = month.getNumberOfDays(); i <= n; i++) {
            
            Day day = month.getDay(i);
            
            if (day.isHoliday()) {
                out.print('*');
            } else {
                out.print(' ');
            }
            
            if (i < 10) {
                out.print(' ');
            }
            out.print(i);
            
            if (day.isHoliday()) {
                out.print('*');
            } else {
                out.print(' ');
            }
            
            if (day.getDayOfWeek() == Calendar.SATURDAY) {
                out.println();
                out.print(INDENT);
            }
            
        }
        
        out.println();
        out.println();
        out.println("===============================");
        
        // I
        
    }
    
}
