package calendar.core;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

/**
 * {̏j\܂B
 * s̏j@ȉjɊւ@j肳Ă̏jƂ܂B
 */
class Holiday {
    
    // j}bṽLbV
    private Map cache = new CacheMap();
    
    /**
     * jIuWFNg𐶐܂B 
     */
    Holiday() {
    }
    
    /**
     * w肵t̓IuWFNgԂ܂B
     * @param date t
     * @return 
     */
    Day getDay(Calendar date) {
        
        // }bṽL[ƂȂÑIuWFNg
        Integer year = new Integer(date.get(Calendar.YEAR));
        
        // jꗗ擾
        Map targetHolidays = (Map)cache.get(year);
        if (targetHolidays == null) {
            // V
            targetHolidays = createNewHolidayMap(year.intValue());
            cache.put(year, new HashMap(targetHolidays));
        }
        
        // w肵tjǂ
        Entry day = new Entry(date);
        if (targetHolidays.containsKey(day)) {
            String remark = (String)targetHolidays.get(day);
            return new Day(date, true, remark);
        } else if (date.get(Calendar.DAY_OF_WEEK) == Calendar.MONDAY) {
            // U֋x(1973/4/12{s)
            if (date.after(new GregorianCalendar(1973, 4-1, 12))) {
                Calendar yesterday = new GregorianCalendar();
                yesterday.setTime(date.getTime());
                yesterday.add(Calendar.DATE, -1);
                day = new Entry(yesterday);
                if (targetHolidays.containsKey(day)) {
                    return new Day(date, true, "U֋x");
                }
            }
        }
        return new Day(date);
        
    }
    
    /**
     * t̓ZoăGgƂĕԂ܂B
     * @param year t̓Zo鐼N
     * @return Gg
     */
    private Entry getVernalEquinoxDay(int year) {
        
        // x = [ rete1 + rate2 * (year - 1900) ] - [ (year - 1900) / 4 ]
        
        double rate1 = 21.4471f;
        double rate2 = 0.242377f;
        
        double result1 = rate1 + rate2 * (year - 1900);
        double result2 = (year - 1900) / 4;
        double result = Math.floor(result1) - Math.floor(result2);
        
        return new Entry(3, (int)result);
        
    }
    
    /**
     * H̓ZoăGgƂĕԂ܂B
     * @param year H̓Zo鐼N
     * @return Gg
     */
    private Entry getAutumnalEquinoxDay(int year) {
        
        // x = [ rete1 + rate2 * (year - 1900) ] - [ (year - 1900) / 4 ]
        
        double rate1 = 23.8896f;
        double rate2 = 0.242032f;
        
        double result1 = rate1 + rate2 * (year - 1900);
        double result2 = (year - 1900) / 4;
        double result = Math.floor(result1) - Math.floor(result2);
        
        return new Entry(9, (int)result);
        
    }
    
    /**
     * nbs[}f[ZoăGgƂĕԂ܂B
     * @param year N
     * @param month 
     * @param ordinal Hj
     * @return Gg
     */
    private Entry getHappyMonday(int year, int month, int ordinal) {
        
        Calendar date = new GregorianCalendar(year, month - 1, 1);
        for (int i = 0; i < 31; i++) {
            if (date.get(Calendar.DAY_OF_WEEK) == Calendar.MONDAY) {
                int dayOfWeekInMonth = date.get(Calendar.DAY_OF_WEEK_IN_MONTH);
                if (dayOfWeekInMonth >= ordinal) {
                    break;
                }
            }
            date.add(Calendar.DATE, +1);
        }
        return new Entry(date);
        
    }
    
    /**
     * Vj}bv쐬܂B
     * @param j}bv̑Ώ۔N
     */
    private Map createNewHolidayMap(int year) {
        
        /*
         * WbN쐬ɂāAȉ̃y[WQlɂ
         * 
         * Addin Box - jɂ
         * http://www.h3.dion.ne.jp/~sakatsu/holiday_topic.htm
         */
        
        Map holidayMap = new HashMap();
        
        // s̏j@ɊÂj
        if (year >= 1949) {
        
            // U
            holidayMap.put(new Entry( 1,  1), "U");
            
            // l̓
            if (year >= 2000) {
                holidayMap.put(getHappyMonday(year, 1, 2), "l̓inbs[}f[j");
            } else {
                holidayMap.put(new Entry( 1, 15), "l̓");
            }
            
            // LO
            if (year >= 1967) {
                holidayMap.put(new Entry( 2, 11), "LO̓");
            }
            
            // t̓
            holidayMap.put(getVernalEquinoxDay(year), "t̓");
            
            // ݂ǂ̓iEVcaj
            if (year >= 1989) {
                holidayMap.put(new Entry( 4, 29), "݂ǂ̓");
            } else {
                holidayMap.put(new Entry( 4, 29), "Vca");
            }
            
            // @LO
            holidayMap.put(new Entry( 5,  3), "@LO");
            
            // ̋x͍Ōɋ߂
                        
            // q̓
            holidayMap.put(new Entry( 5,  5), "q̓");
            
            // C̓
            if (year >= 1996) {
                if (year >= 2003) {
                    holidayMap.put(getHappyMonday(year, 7, 3), "C̓inbs[}f[j");
                } else {
                    holidayMap.put(new Entry( 7, 19), "C̓");
                }
            }
            
            // hV̓
            Entry respectForTheAgedDay = null;
            if (year >= 1966) {
                if (year >= 2003) {
                    respectForTheAgedDay = getHappyMonday(year, 9, 3);
                    holidayMap.put(respectForTheAgedDay, "hV̓inbs[}f[j");
                } else {
                    respectForTheAgedDay = new Entry( 9, 15);
                    holidayMap.put(respectForTheAgedDay, "hV̓");
                }
            }
            
            // H̓
            Entry autumnalEquinoxDay = getAutumnalEquinoxDay(year);
            holidayMap.put(autumnalEquinoxDay, "H̓");
            
            // ̈̓
            if (year >= 1966) {
                if (year >= 2003) {
                    holidayMap.put(getHappyMonday(year, 10, 2), "̈̓inbs[}f[j");
                } else {
                    holidayMap.put(new Entry(10, 10), "̈̓");
                }
            }
            
            // ̓
            holidayMap.put(new Entry(11,  3), "̓");
            
            // ΘJӂ̓
            holidayMap.put(new Entry(11, 23), "ΘJӂ̓");
            
            // Vca
            if (year >= 1989) {
                holidayMap.put(new Entry(12, 23), "Vca");
            }
            
            /*
             * ̋xɂ
             * 
             * ̋x́A`(j@RR)WbN
             * ʂȂ̂ŁAł̎ZoʂpB
             * 
             * ̓Iɂ́A2004N10݁A
             * ̋xɂȂ肤
             * Eu@LOv(5/3)Ɓuǂ̓v(5/5)
             * EuhV̓v(93j)ƁuH̓v(9/22,23)
             *    hV̓̃nbs[}f[́A2003/1/1Ɏ{sꂽB
             * Ȃ̂ŁÂQӏ`FbNB
             * ܂Aűx@v{sꂽ̂1985/12/27A
             * L̗RɂAu1986Nȍ~vƂB
             * 
             * 5/4͏ɋx݂ƂȂ邪A͈قȂB
             * Ej̏ꍇ́Aj
             * Ej̏ꍇ́A@LO̐U֋x
             * ELȊȌꍇ́A̋xŏj
             */
            if (year >= 1986) {
                // TS̃`FbN
                Calendar calendar = new GregorianCalendar(year, 5 - 1, 4);
                int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
                if (dayOfWeek != Calendar.SUNDAY && dayOfWeek != Calendar.MONDAY) {
                    holidayMap.put(new Entry(5, 4), "̋x");
                }
            }
            if (year >= 2003) {
                // hV̓ƏH̓`FbN
                if (respectForTheAgedDay.date == autumnalEquinoxDay.date - 2) {
                    holidayMap.put(new Entry(9, respectForTheAgedDay.date + 1), "̋x");
                }
            }
            
        } else {
            
            /*
             * j@ȑȌtEH H
             */
            
            // t̓
            holidayMap.put(getVernalEquinoxDay(year), "t̓ (jH)");
            // H̓
            holidayMap.put(getAutumnalEquinoxDay(year), "H̓ (jH)");
            
        }
        
        return holidayMap;
        
    }
    
    /**
     * \GgłB
     */
    private static class Entry {
        
        int month;
        int date;
        
        /**
         * Gg𐶐܂B
         * @param month 
         * @param date 
         */
        Entry(int month, int date) {
            
            this.month = month;
            this.date = date;
            
        }
        
        /**
         * Gg𐶐܂B
         * @param calendar t
         */
        Entry(Calendar calendar) {
            
            this.month = calendar.get(Calendar.MONTH) + 1;
            this.date = calendar.get(Calendar.DATE);
            
        }
        
        /**
         * ʂ̃IuWFNgƔr܂B
         * \ꍇ͓ƌȂ܂B
         * @return <code>true</code>AłȂ<code>false</code>
         */
        public boolean equals(Object object) {
            
            if (object instanceof Entry) {
                
                Entry another = (Entry)object;
                return (month == another.month && date == another.date);
                
            } else {
                
                return false;
                
            }
            
        }
        
        /**
         * nbVR[hԂ܂B
         * @return nbVR[h
         */
        public int hashCode() {
            
            return (month * 32 + date);
            
        }
        
        /**
         * ̃IuWFNg̕\Ԃ܂B
         * @return \
         */
        public String toString() {
            
            StringBuffer sb = new StringBuffer();
            sb.append(month);
            sb.append('/');
            sb.append(date);
            return sb.toString();
            
        }
        
    }
    
}
